/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.util;

import io.basc.framework.util.Assert;
import io.basc.framework.util.Registration;
import io.basc.framework.util.RegistrationException;

public class MergedRegistration
implements Registration {
    private final Registration left;
    private final Registration right;

    public MergedRegistration(Registration left, Registration right) {
        Assert.requiredArgument(left != null, "left");
        Assert.requiredArgument(right != null, "right");
        this.left = left;
        this.right = right;
    }

    @Override
    public void unregister() throws RegistrationException {
        try {
            this.left.unregister();
        }
        finally {
            this.right.unregister();
        }
    }

    @Override
    public boolean isEmpty() {
        return this.left.isEmpty() && this.right.isEmpty();
    }

    public static Registration merge(Registration left, Registration right) {
        if (right == null || right == EMPTY) {
            return left;
        }
        if (left == null || left == EMPTY) {
            return right;
        }
        return new MergedRegistration(left, right);
    }

    public Registration getLeft() {
        return this.left;
    }

    public Registration getRight() {
        return this.right;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MergedRegistration)) {
            return false;
        }
        MergedRegistration other = (MergedRegistration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Registration this$left = this.getLeft();
        Registration other$left = other.getLeft();
        if (this$left == null ? other$left != null : !this$left.equals(other$left)) {
            return false;
        }
        Registration this$right = this.getRight();
        Registration other$right = other.getRight();
        return !(this$right == null ? other$right != null : !this$right.equals(other$right));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MergedRegistration;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Registration $left = this.getLeft();
        result = result * 59 + ($left == null ? 43 : $left.hashCode());
        Registration $right = this.getRight();
        result = result * 59 + ($right == null ? 43 : $right.hashCode());
        return result;
    }

    public String toString() {
        return "MergedRegistration(left=" + this.getLeft() + ", right=" + this.getRight() + ")";
    }
}

