/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.util;

import io.basc.framework.util.CollectionUtils;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;

public final class MultiEnumeration<E>
implements Enumeration<E> {
    private Iterator<Enumeration<E>> iterator;
    private Enumeration<? extends E> enumeration;

    public MultiEnumeration(Collection<Enumeration<E>> enumerations) {
        this.iterator = CollectionUtils.isEmpty(enumerations) ? null : enumerations.iterator();
    }

    @Override
    public boolean hasMoreElements() {
        if (this.enumeration != null && this.enumeration.hasMoreElements()) {
            return true;
        }
        while (this.iterator != null && this.iterator.hasNext()) {
            this.enumeration = this.iterator.next();
            if (this.enumeration != null && this.enumeration.hasMoreElements()) {
                return true;
            }
            this.enumeration = null;
        }
        return false;
    }

    @Override
    public E nextElement() {
        if (this.enumeration == null) {
            throw new UnsupportedOperationException("Call the hasnext method first");
        }
        return this.enumeration.nextElement();
    }
}

