/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.util;

import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;

public final class MultiIterable<E>
implements Iterable<E> {
    private final Iterable<? extends Iterable<? extends E>> iterables;

    @SafeVarargs
    public MultiIterable(Iterable<? extends E> ... iterables) {
        this((Iterable<Iterable<? extends E>>)Arrays.asList(iterables));
    }

    public MultiIterable(Iterable<? extends Iterable<? extends E>> iterables) {
        this.iterables = iterables;
    }

    @Override
    public Iterator<E> iterator() {
        return new InternalIterator();
    }

    private final class InternalIterator
    implements Iterator<E> {
        private Iterator<? extends Iterable<? extends E>> iterator;
        private Iterator<? extends E> valueIterator;

        private InternalIterator() {
            this.iterator = MultiIterable.this.iterables == null ? null : MultiIterable.this.iterables.iterator();
        }

        @Override
        public boolean hasNext() {
            if (this.valueIterator != null && this.valueIterator.hasNext()) {
                return true;
            }
            while (this.iterator != null && this.iterator.hasNext()) {
                Iterable iterable = this.iterator.next();
                if (iterable == null) continue;
                this.valueIterator = iterable.iterator();
                if (this.valueIterator.hasNext()) {
                    return true;
                }
                this.valueIterator = null;
            }
            return false;
        }

        @Override
        public E next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.valueIterator.next();
        }
    }
}

