/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.util;

import io.basc.framework.util.CollectionUtils;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public interface MultiValueMap<K, V>
extends Map<K, List<V>> {
    public V getFirst(K var1);

    public void add(K var1, V var2);

    public void set(K var1, V var2);

    public void setAll(Map<K, V> var1);

    default public void addAll(Map<K, List<V>> map) {
        for (Map.Entry<K, List<V>> entry : map.entrySet()) {
            List<V> values = entry.getValue();
            if (values == null) continue;
            for (V value : values) {
                this.add(entry.getKey(), value);
            }
        }
    }

    default public Map<K, V> toSingleValueMap() {
        if (this.isEmpty()) {
            return Collections.emptyMap();
        }
        LinkedHashMap singleValueMap = new LinkedHashMap(this.size());
        for (Map.Entry entry : this.entrySet()) {
            List values = (List)entry.getValue();
            if (CollectionUtils.isEmpty(values)) continue;
            singleValueMap.put(entry.getKey(), values.get(0));
        }
        return singleValueMap;
    }
}

