/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.util;

import io.basc.framework.codec.Codec;
import io.basc.framework.codec.DecodeException;
import io.basc.framework.codec.EncodeException;
import io.basc.framework.util.Assert;
import io.basc.framework.util.NumberUtils;
import io.basc.framework.util.StringUtils;
import java.math.BigDecimal;

public final class NumberReplacer
implements Codec<BigDecimal, String> {
    private static final String[] CHINESE_NUMBERS = new String[]{"\u96f6", "\u4e00", "\u4e8c", "\u4e09", "\u56db", "\u4e94", "\u516d", "\u4e03", "\u516b", "\u4e5d"};
    private static final String[] CAPITALIZE_CHINESE_NUMBERS = new String[]{"\u96f6", "\u58f9", "\u8d30", "\u53c1", "\u8086", "\u4f0d", "\u9646", "\u67d2", "\u634c", "\u7396", "\u62fe"};
    private final String[] mapping;
    private final boolean stripTrailingZeros;
    public static final NumberReplacer LOWERCASE = new NumberReplacer(false, true);
    public static final NumberReplacer CAPITALIZE = new NumberReplacer(true, true);

    public NumberReplacer(boolean capitalize, boolean stripTrailingZeros) {
        this(capitalize ? CAPITALIZE_CHINESE_NUMBERS : CHINESE_NUMBERS, stripTrailingZeros);
    }

    public NumberReplacer(String[] mapping, boolean stripTrailingZeros) {
        Assert.requiredArgument(mapping != null, "mapping");
        this.mapping = mapping;
        this.stripTrailingZeros = stripTrailingZeros;
    }

    public String[] getMapping() {
        return (String[])this.mapping.clone();
    }

    public boolean isStripTrailingZeros() {
        return this.stripTrailingZeros;
    }

    @Override
    public String encode(BigDecimal source) throws EncodeException {
        if (source == null) {
            return null;
        }
        String value = (this.stripTrailingZeros ? NumberUtils.stripTrailingZeros(source) : source).toPlainString();
        return this.encode(value);
    }

    @Override
    public String encode(CharSequence source) throws EncodeException {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < source.length(); ++i) {
            char v = source.charAt(i);
            if (Character.isDigit(v)) {
                sb.append(this.format(v));
                continue;
            }
            sb.append(v);
        }
        return sb.toString();
    }

    @Override
    public BigDecimal decode(String source) throws DecodeException {
        if (source == null) {
            return null;
        }
        String value = source;
        for (int i = 0; i < this.mapping.length; ++i) {
            value = value.replaceAll(this.mapping[i], i + "");
        }
        BigDecimal number = new BigDecimal(value);
        return this.stripTrailingZeros ? NumberUtils.stripTrailingZeros(number) : number;
    }

    public String format(char source) {
        Assert.requiredArgument(Character.isDigit(source), "Source must be a digital");
        return this.mapping[Character.getNumericValue(source)];
    }

    public int parse(String source) {
        if (StringUtils.isEmpty(source)) {
            return -1;
        }
        for (int i = 0; i < this.mapping.length; ++i) {
            if (!StringUtils.equals(source, this.mapping[i])) continue;
            return i;
        }
        return -1;
    }

    public boolean contains(String source) {
        return this.parse(source) != -1;
    }

    public boolean exists(String source) {
        if (StringUtils.isEmpty(source)) {
            return false;
        }
        for (String v : this.mapping) {
            if (source.indexOf(v) == -1) continue;
            return true;
        }
        return false;
    }
}

