/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.util;

import io.basc.framework.env.BascObject;
import io.basc.framework.util.Assert;
import java.io.Serializable;
import java.math.BigDecimal;

public class NumberUnit
extends BascObject
implements Serializable,
Comparable<NumberUnit> {
    private static final long serialVersionUID = 1L;
    public static final NumberUnit MONEY_001 = new NumberUnit("\u5206", "0.01");
    public static final NumberUnit MONEY_01 = new NumberUnit("\u89d2", "0.1");
    public static final NumberUnit MONEY = new NumberUnit("\u5143", 1L);
    public static final NumberUnit MONEY_10 = new NumberUnit("\u62fe", 10L);
    public static final NumberUnit MONEY_100 = new NumberUnit("\u4f70", 100L);
    public static final NumberUnit MONEY_1000 = new NumberUnit("\u4edf", 1000L);
    public static final NumberUnit MONEY_10000 = new NumberUnit("\u4e07", 10000L);
    public static final NumberUnit MONEY_100000000 = new NumberUnit("\u4ebf", 100000000L);
    public static final NumberUnit B = new NumberUnit("B", 1L);
    public static final NumberUnit KB = new NumberUnit("KB", 1024L);
    public static final NumberUnit MB = new NumberUnit("MB", 0x100000L);
    public static final NumberUnit GB = new NumberUnit("GB", 0x40000000L);
    public static final NumberUnit TB = new NumberUnit("TB", 0x10000000000L);
    private final String name;
    private final BigDecimal radix;

    public NumberUnit(String name, long radix) {
        this(name, new BigDecimal(radix));
    }

    public NumberUnit(String name, String radix) {
        this(name, new BigDecimal(radix));
    }

    public NumberUnit(String name, BigDecimal radix) {
        Assert.requiredArgument(name != null, "name");
        Assert.requiredArgument(radix != null && radix.compareTo(BigDecimal.ZERO) > 0, "radix");
        this.name = name;
        this.radix = radix;
    }

    public String getName() {
        return this.name;
    }

    public BigDecimal getRadix() {
        return this.radix;
    }

    @Override
    public int compareTo(NumberUnit o) {
        return this.radix.compareTo(o.radix);
    }
}

