/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.util;

import io.basc.framework.core.reflect.ReflectionUtils;
import io.basc.framework.util.ArrayUtils;
import io.basc.framework.util.ClassUtils;
import io.basc.framework.util.CollectionFactory;
import io.basc.framework.util.CollectionUtils;
import io.basc.framework.util.StringUtils;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Map;

public abstract class ObjectUtils {
    public static final Object[] EMPTY_ARRAY = new Object[0];

    public static boolean isCheckedException(Throwable ex) {
        return !(ex instanceof RuntimeException) && !(ex instanceof Error);
    }

    public static boolean isCompatibleWithThrowsClause(Throwable ex, Class[] declaredExceptions) {
        if (!ObjectUtils.isCheckedException(ex)) {
            return true;
        }
        if (declaredExceptions != null) {
            for (int i = 0; i < declaredExceptions.length; ++i) {
                if (!declaredExceptions[i].isAssignableFrom(ex.getClass())) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isArray(Object obj) {
        return obj != null && obj.getClass().isArray();
    }

    public static boolean isEmpty(Object obj) {
        if (obj == null) {
            return true;
        }
        if (obj instanceof CharSequence) {
            return StringUtils.isEmpty((CharSequence)obj);
        }
        if (obj instanceof Collection) {
            return CollectionUtils.isEmpty((Collection)obj);
        }
        if (obj instanceof Map) {
            return CollectionUtils.isEmpty((Map)obj);
        }
        if (obj.getClass().isArray()) {
            return Array.getLength(obj) == 0;
        }
        return false;
    }

    public static boolean containsElement(Object[] array, Object element) {
        if (array == null) {
            return false;
        }
        for (Object arrayEle : array) {
            if (!ObjectUtils.equals(arrayEle, element)) continue;
            return true;
        }
        return false;
    }

    public static boolean containsConstant(Enum<?>[] enumValues, String constant) {
        return ObjectUtils.containsConstant(enumValues, constant, false);
    }

    public static boolean containsConstant(Enum<?>[] enumValues, String constant, boolean caseSensitive) {
        for (Enum<?> candidate : enumValues) {
            if (!(caseSensitive ? candidate.toString().equals(constant) : candidate.toString().equalsIgnoreCase(constant))) continue;
            return true;
        }
        return false;
    }

    public static <E extends Enum<?>> E caseInsensitiveValueOf(E[] enumValues, String constant) {
        for (E candidate : enumValues) {
            if (!((Enum)candidate).toString().equalsIgnoreCase(constant)) continue;
            return candidate;
        }
        throw new IllegalArgumentException(String.format("constant [%s] does not exist in enum type %s", constant, enumValues.getClass().getComponentType().getName()));
    }

    public static <A, O extends A> A[] addObjectToArray(A[] array, O obj) {
        Class compType = Object.class;
        if (array != null) {
            compType = array.getClass().getComponentType();
        } else if (obj != null) {
            compType = obj.getClass();
        }
        int newArrLength = array != null ? array.length + 1 : 1;
        Object[] newArr = (Object[])Array.newInstance(compType, newArrLength);
        if (array != null) {
            System.arraycopy(array, 0, newArr, 0, array.length);
        }
        newArr[newArr.length - 1] = obj;
        return newArr;
    }

    public static Object[] toObjectArray(Object source) {
        if (source instanceof Object[]) {
            return (Object[])source;
        }
        if (source == null) {
            return new Object[0];
        }
        if (!source.getClass().isArray()) {
            throw new IllegalArgumentException("Source is not an array: " + source);
        }
        int length = Array.getLength(source);
        if (length == 0) {
            return new Object[0];
        }
        Class<?> wrapperType = Array.get(source, 0).getClass();
        Object[] newArray = (Object[])Array.newInstance(wrapperType, length);
        for (int i = 0; i < length; ++i) {
            newArray[i] = Array.get(source, i);
        }
        return newArray;
    }

    public static String toString(Object source, boolean deep) {
        if (source == null) {
            return null;
        }
        if (source.getClass().isArray()) {
            return ArrayUtils.toString(source, deep);
        }
        return source.toString();
    }

    public static String toString(Object source) {
        return ObjectUtils.toString(source, true);
    }

    public static int hashCode(Object source, boolean deep) {
        if (source == null) {
            return 0;
        }
        if (source.getClass().isArray()) {
            return ArrayUtils.hashCode(source, deep);
        }
        return source.hashCode();
    }

    public static int hashCode(Object source) {
        return ObjectUtils.hashCode(source, true);
    }

    public static boolean equals(Object left, Object right, boolean deep) {
        if (left == right) {
            return true;
        }
        if (left == null || right == null) {
            return false;
        }
        if (left.equals(right)) {
            return true;
        }
        if (left.getClass().isArray() && right.getClass().isArray()) {
            return ArrayUtils.equals(left, right, deep);
        }
        return false;
    }

    public static boolean equals(Object left, Object right) {
        return ObjectUtils.equals(left, right, true);
    }

    public static <T> T clone(T source) {
        return ObjectUtils.clone(source, false);
    }

    public static <T> T clone(T source, boolean deep) {
        if (source == null) {
            return null;
        }
        if (source instanceof String || source instanceof Class) {
            return source;
        }
        if (ClassUtils.isPrimitiveOrWrapper(source.getClass()) || source.getClass().isEnum()) {
            return source;
        }
        if (source.getClass().isArray()) {
            return ArrayUtils.clone(source, deep);
        }
        if (source instanceof Collection) {
            return (T)CollectionFactory.clone((Collection)source, deep);
        }
        if (source instanceof Map) {
            return (T)CollectionFactory.clone((Map)source, deep);
        }
        if (!deep) {
            try {
                Object target = ReflectionUtils.invokeCloneMethod(source);
                if (target != null) {
                    return target;
                }
            }
            catch (StackOverflowError stackOverflowError) {
                // empty catch block
            }
        }
        return ReflectionUtils.clone(source, deep);
    }
}

