/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.util;

import io.basc.framework.util.Assert;
import io.basc.framework.util.ConsumeProcessor;
import io.basc.framework.util.DefaultOptional;
import io.basc.framework.util.Source;
import io.basc.framework.util.StandardOptional;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;

public interface Optional<T>
extends Supplier<T> {
    public static <U> Optional<U> empty() {
        return Optional.ofNullable(null);
    }

    public static <U> Optional<U> of(U value) {
        Assert.requiredArgument(value != null, "value");
        return new DefaultOptional<U>(value);
    }

    public static <U> Optional<U> ofNullable(U value) {
        return new DefaultOptional<U>(value);
    }

    public static <U> Optional<U> ofSupplier(Supplier<? extends U> valueSupplier) {
        return new StandardOptional<U>(valueSupplier);
    }

    @Override
    public T get();

    public boolean isPresent();

    default public <E extends Throwable> void ifPresent(ConsumeProcessor<? super T, ? extends E> consumer) throws E {
        if (this.isPresent()) {
            consumer.process(this.get());
        }
    }

    default public Optional<T> ifAbsentGet(Supplier<? extends T> other) {
        Objects.requireNonNull(other);
        return Optional.ofSupplier(() -> this.orElse(other.get()));
    }

    default public Optional<T> ifAbsent(T other) {
        return this.ifAbsentGet(() -> other);
    }

    default public Optional<T> filter(Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate);
        return Optional.ofSupplier(() -> {
            Object value = this.orElse(null);
            if (value == null) {
                return null;
            }
            return predicate.test((T)value) ? null : value;
        });
    }

    default public <U> Optional<U> map(Function<? super T, ? extends U> mapper) {
        Objects.requireNonNull(mapper);
        return this.convert(e -> e == null ? null : mapper.apply(e));
    }

    default public <U> Optional<U> convert(Function<? super T, ? extends U> converter) {
        Objects.requireNonNull(converter);
        return Optional.ofSupplier(() -> {
            Object value = this.orElse(null);
            return converter.apply((T)value);
        });
    }

    default public <U> Optional<U> flatMap(Function<? super T, Optional<U>> mapper) {
        Objects.requireNonNull(mapper);
        if (this.isPresent()) {
            return Objects.requireNonNull(mapper.apply(this.get()));
        }
        return Optional.empty();
    }

    default public T orElse(T other) {
        return this.isPresent() ? this.get() : other;
    }

    default public <E extends Throwable> T orElseGet(Source<? extends T, ? extends E> other) throws E {
        return this.isPresent() ? this.get() : other.get();
    }

    default public <X extends Throwable> T orElseThrow(Supplier<? extends X> exceptionSupplier) throws X {
        if (this.isPresent()) {
            return this.get();
        }
        throw (Throwable)exceptionSupplier.get();
    }
}

