/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.util;

import io.basc.framework.util.DefaultOptionalDouble;
import io.basc.framework.util.DoubleConsumerProcessor;
import io.basc.framework.util.Optional;
import java.util.function.DoubleFunction;
import java.util.function.DoublePredicate;
import java.util.function.DoubleSupplier;
import java.util.function.Predicate;

public interface OptionalDouble
extends Optional<Double>,
DoubleSupplier {
    public static OptionalDouble empty() {
        return DefaultOptionalDouble.EMPTY;
    }

    public static OptionalDouble of(double value) {
        return new DefaultOptionalDouble(value);
    }

    default public <E extends Throwable> void ifPresent(DoubleConsumerProcessor<? extends E> consumer) throws E {
        if (this.isPresent()) {
            consumer.process(this.getAsDouble());
        }
    }

    @Override
    default public double orElse(double other) {
        if (this.isPresent()) {
            return this.getAsDouble();
        }
        return other;
    }

    public OptionalDouble filter(Predicate<? super Double> var1);

    public OptionalDouble filter(DoublePredicate var1);

    public <U> Optional<U> map(DoubleFunction<? extends U> var1);

    public <U> Optional<U> flatMap(DoubleFunction<Optional<U>> var1);
}

