/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.util;

import io.basc.framework.lang.Nullable;
import io.basc.framework.util.Parents;
import io.basc.framework.util.ReversibleIterator;

public interface ParentDiscover<T extends ParentDiscover<T>> {
    @Nullable
    public T getParent();

    default public boolean hasParent() {
        return this.getParent() != null;
    }

    default public ReversibleIterator<T> parents() {
        return new Parents(this);
    }

    default public boolean isParents(T parent) {
        if (parent == null || !this.hasParent()) {
            return false;
        }
        T p = this.getParent();
        while (p != parent && !parent.equals(p)) {
            if (!p.hasParent()) {
                return false;
            }
            p = p.getParent();
        }
        return true;
    }
}

