/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.util;

import io.basc.framework.lang.Nullable;
import io.basc.framework.util.AppendTo;
import io.basc.framework.util.FormatUtils;
import java.io.IOException;
import java.io.Serializable;
import java.util.function.Supplier;

public final class PlaceholderMessage
implements AppendTo,
Serializable,
Supplier<String> {
    private static final long serialVersionUID = 1L;
    private final Object msg;
    private final Object[] args;
    private final String placeholder;

    public PlaceholderMessage(Object msg, @Nullable String placeholder, Object[] args) {
        this.msg = msg;
        this.placeholder = placeholder;
        this.args = args;
    }

    public Object getMsg() {
        return this.msg;
    }

    public Object[] getArgs() {
        return this.args;
    }

    public String getPlaceholder() {
        return this.placeholder;
    }

    @Override
    public void appendTo(Appendable appendable) throws IOException {
        FormatUtils.formatPlaceholder(appendable, this.msg, this.placeholder, this.args);
    }

    @Override
    public String get() {
        return this.toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        try {
            this.appendTo(sb);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return sb.toString();
    }
}

