/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.util;

import io.basc.framework.util.Assert;
import java.math.BigInteger;
import java.util.Iterator;
import java.util.function.Function;

public class PositionIterator<E>
implements Iterator<E> {
    private BigInteger start;
    private final BigInteger end;
    private final Function<? super BigInteger, ? extends E> getter;

    public PositionIterator(BigInteger end, Function<? super BigInteger, ? extends E> getter) {
        this(BigInteger.ZERO, end, getter);
    }

    public BigInteger getPosition() {
        return this.start;
    }

    public PositionIterator(BigInteger start, BigInteger end, Function<? super BigInteger, ? extends E> getter) {
        Assert.requiredArgument(start != null, "start");
        Assert.requiredArgument(end != null, "end");
        Assert.requiredArgument(getter != null, "getter");
        this.start = start;
        this.end = end;
        this.getter = getter;
    }

    @Override
    public boolean hasNext() {
        return this.end.compareTo(this.start) > 0;
    }

    @Override
    public E next() {
        try {
            E e = this.getter.apply(this.start);
            return e;
        }
        finally {
            this.start = this.start.add(BigInteger.ONE);
        }
    }
}

