/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.util;

import io.basc.framework.lang.Nullable;
import io.basc.framework.util.Assert;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;

@FunctionalInterface
public interface Processor<S, T, E extends Throwable> {
    public T process(S var1) throws E;

    default public <V> Processor<V, T, E> compose(Processor<? super V, ? extends S, ? extends E> before) {
        Objects.requireNonNull(before);
        return s -> this.process(before.process((Object)s));
    }

    default public <V> Processor<S, V, E> andThen(Processor<? super T, ? extends V, ? extends E> after) {
        Objects.requireNonNull(after);
        return s -> after.process((T)this.process(s));
    }

    public static <U, X extends Throwable> Processor<U, U, X> identity() {
        return t -> t;
    }

    default public <X extends Throwable> Processor<S, T, X> exceptionConvert(Processor<? super Throwable, ? extends X, ? extends X> exceptionConverter) {
        return s -> {
            try {
                return this.process(s);
            }
            catch (Throwable e) {
                throw (Throwable)exceptionConverter.process(e);
            }
        };
    }

    default public <TC extends Collection<T>> TC processAll(Iterator<? extends S> sourceIterator, TC targets) throws E {
        if (sourceIterator == null) {
            return targets;
        }
        while (sourceIterator.hasNext()) {
            S source = sourceIterator.next();
            T target = this.process(source);
            targets.add(target);
        }
        return targets;
    }

    default public <TL extends Collection<T>> TL processAll(Iterable<? extends S> sources, TL targets) throws E {
        if (sources == null) {
            return targets;
        }
        return this.processAll(sources.iterator(), targets);
    }

    default public List<T> processAll(Iterator<? extends S> sourceIterator) throws E {
        if (sourceIterator == null) {
            return null;
        }
        if (!sourceIterator.hasNext()) {
            return Collections.emptyList();
        }
        return this.processAll((Iterator<? extends S>)sourceIterator, (Collection)new ArrayList());
    }

    default public List<T> processAll(Iterable<? extends S> sources) throws E {
        if (sources == null) {
            return null;
        }
        return this.processAll(sources.iterator());
    }

    default public Set<T> processAll(Set<? extends S> sources) throws E {
        if (sources == null) {
            return null;
        }
        if (sources.isEmpty()) {
            return Collections.emptySet();
        }
        return this.processAll(sources.iterator(), (Collection)new LinkedHashSet(sources.size()));
    }

    @Nullable
    default public T[] processAll(S ... sources) throws E {
        if (sources == null) {
            return null;
        }
        Object array = null;
        for (int i = 0; i < sources.length; ++i) {
            T target = this.process(sources[i]);
            if (target == null) continue;
            if (array == null) {
                array = Array.newInstance(target.getClass(), sources.length);
            }
            Array.set(array, i, target);
        }
        return (Object[])array;
    }

    default public T[] processAll(S[] sources, T[] targets) throws E {
        return this.processAll(sources, 0, targets, 0);
    }

    default public T[] processAll(S[] sources, int sourceIndex, T[] targets, int targetIndex) throws E {
        Assert.requiredArgument(sources != null, "sources");
        Assert.requiredArgument(targets != null, "targets");
        int i = sourceIndex;
        int insertIndex = targetIndex;
        while (sourceIndex < sources.length) {
            S source = sources[i];
            T target = this.process(source);
            targets[insertIndex] = target;
            ++i;
            ++insertIndex;
        }
        return targets;
    }

    public static <A, B, X extends Throwable> Processor<A, B, X> of(Function<? super A, ? extends B> function) {
        return s -> function.apply((Object)s);
    }

    public static <A, B, X extends Throwable, TC extends Collection<B>> TC processAll(Iterator<? extends A> sourceIterator, TC targets, Processor<? super A, B, ? extends X> processor) throws X {
        return processor.processAll(sourceIterator, targets);
    }

    public static <A, B, X extends Throwable, TL extends Collection<B>> TL processAll(Iterable<? extends A> sources, TL targets, Processor<? super A, B, ? extends X> processor) throws X {
        return processor.processAll(sources.iterator(), targets);
    }

    public static <A, B, X extends Throwable> List<B> processAll(Iterator<? extends A> sourceIterator, Processor<? super A, B, ? extends X> processor) throws X {
        return processor.processAll(sourceIterator);
    }

    public static <A, B, X extends Throwable> List<B> processAll(Iterable<? extends A> sources, Processor<? super A, B, ? extends X> processor) throws X {
        return processor.processAll(sources);
    }

    public static <A, B, X extends Throwable> Set<B> processAll(Set<? extends A> sources, Processor<? super A, B, ? extends X> processor) throws X {
        return processor.processAll(sources);
    }

    public static <A, B, X extends Throwable> B[] processAll(A[] sources, Processor<? super A, B, ? extends X> processor) throws X {
        return processor.processAll(sources);
    }

    public static <A, B, X extends Throwable> B[] processAll(A[] sources, B[] targets, Processor<? super A, B, ? extends X> processor) throws X {
        return processor.processAll((S[])sources, (T[])targets);
    }

    public static <A, B, X extends Throwable> B[] processAll(A[] sources, int sourceIndex, B[] targets, int targetIndex, Processor<? super A, B, ? extends X> processor) throws X {
        return processor.processAll(sources, sourceIndex, targets, targetIndex);
    }
}

