/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.util;

import io.basc.framework.lang.Nullable;
import io.basc.framework.math.Addition;
import io.basc.framework.math.NumberComparator;
import io.basc.framework.util.Assert;
import io.basc.framework.util.Processor;
import io.basc.framework.util.StringUtils;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Iterator;
import java.util.Random;
import java.util.function.Predicate;

public final class RandomUtils {
    public static final char[] CAPITAL_LETTERS = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z'};
    public static final char[] LOWERCASE_LETTERS = new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};
    public static final char[] NUMBERIC_CHARACTER = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
    public static final char[] EASY_TO_DISTINGUISH = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'c', 'd', 'e', 'f', 'h', 'k', 'm', 'n', 'p', 'r', 's', 't', 'v', 'w', 'y', 'A', 'B', 'C', 'E', 'F', 'G', 'H', 'K', 'M', 'N', 'R', 'S', 'T', 'V', 'W', 'Y'};
    public static final char[] ALL = StringUtils.mergeCharArray(NUMBERIC_CHARACTER, LOWERCASE_LETTERS, CAPITAL_LETTERS);

    private RandomUtils() {
    }

    public static int random(Random random, int min, int max) {
        if (max == min) {
            return min;
        }
        return (int)(random.nextDouble() * (double)(max - min)) + min;
    }

    public static int random(int min, int max) {
        if (max == min) {
            return min;
        }
        return (int)(Math.random() * (double)(max - min)) + min;
    }

    public static long random(Random random, long min, long max) {
        if (max == min) {
            return min;
        }
        return (long)(random.nextDouble() * (double)(max - min)) + min;
    }

    public static long random(long min, long max) {
        if (max == min) {
            return min;
        }
        return (long)(Math.random() * (double)(max - min)) + min;
    }

    public static BigDecimal random(Random random, BigDecimal min, BigDecimal max) {
        Assert.requiredArgument(min != null, "min");
        Assert.requiredArgument(max != null, "max");
        if (min.equals(max)) {
            return min;
        }
        return new BigDecimal(random.nextDouble() + "").multiply(max.subtract(min)).add(min);
    }

    public static BigDecimal random(BigDecimal min, BigDecimal max) {
        Assert.requiredArgument(min != null, "min");
        Assert.requiredArgument(max != null, "max");
        if (min.equals(max)) {
            return min;
        }
        return new BigDecimal(Math.random() + "").multiply(max.subtract(min)).add(min);
    }

    public static BigInteger random(Random random, BigInteger min, BigInteger max) {
        Assert.requiredArgument(min != null, "min");
        Assert.requiredArgument(max != null, "max");
        if (min.equals(max)) {
            return min;
        }
        return new BigInteger(random.nextDouble() + "").multiply(max.subtract(min)).add(min);
    }

    public static BigInteger random(BigInteger min, BigInteger max) {
        Assert.requiredArgument(min != null, "min");
        Assert.requiredArgument(max != null, "max");
        if (min.equals(max)) {
            return min;
        }
        return new BigInteger(Math.random() + "").multiply(max.subtract(min)).add(min);
    }

    public static Number random(Random random, Number min, Number max) {
        Assert.requiredArgument(min != null, "min");
        Assert.requiredArgument(max != null, "max");
        if (min.equals(max)) {
            return min;
        }
        if (min instanceof BigDecimal || min instanceof Float || min instanceof Double || max instanceof BigDecimal || max instanceof Float || max instanceof Double) {
            return RandomUtils.random(random, (BigDecimal)Addition.INSTANCE.eval(BigDecimal.ZERO, min), (BigDecimal)Addition.INSTANCE.eval(BigDecimal.ZERO, max));
        }
        if (max instanceof BigInteger || min instanceof BigInteger) {
            return RandomUtils.random(random, (BigInteger)Addition.INSTANCE.eval(BigInteger.ZERO, min), (BigInteger)Addition.INSTANCE.eval(BigInteger.ZERO, max));
        }
        return RandomUtils.random(random, min.longValue(), max.longValue());
    }

    public static Number random(Number min, Number max) {
        Assert.requiredArgument(min != null, "min");
        Assert.requiredArgument(max != null, "max");
        return RandomUtils.random(new Random(), min, max);
    }

    public static <T> T random(Random random, T[] array) {
        Assert.requiredArgument(random != null, "random");
        Assert.requiredArgument(array != null && array.length != 0, "array");
        return array[random.nextInt(array.length)];
    }

    public static int random(Random random, int[] array) {
        Assert.requiredArgument(random != null, "random");
        Assert.requiredArgument(array != null && array.length != 0, "array");
        return array[random.nextInt(array.length)];
    }

    public static long random(Random random, long[] array) {
        Assert.requiredArgument(random != null, "random");
        Assert.requiredArgument(array != null && array.length != 0, "array");
        return array[random.nextInt(array.length)];
    }

    public static short random(Random random, short[] array) {
        Assert.requiredArgument(random != null, "random");
        Assert.requiredArgument(array != null && array.length != 0, "array");
        return array[random.nextInt(array.length)];
    }

    public static byte random(Random random, byte[] array) {
        Assert.requiredArgument(random != null, "random");
        Assert.requiredArgument(array != null && array.length != 0, "array");
        return array[random.nextInt(array.length)];
    }

    public static float random(Random random, float[] array) {
        Assert.requiredArgument(random != null, "random");
        Assert.requiredArgument(array != null && array.length != 0, "array");
        return array[random.nextInt(array.length)];
    }

    public static double random(Random random, double[] array) {
        Assert.requiredArgument(random != null, "random");
        Assert.requiredArgument(array != null && array.length != 0, "array");
        return array[random.nextInt(array.length)];
    }

    public static boolean random(Random random, boolean[] array) {
        Assert.requiredArgument(random != null, "random");
        Assert.requiredArgument(array != null && array.length != 0, "array");
        return array[random.nextInt(array.length)];
    }

    public static char random(Random random, char[] array) {
        Assert.requiredArgument(random != null, "random");
        Assert.requiredArgument(array != null && array.length != 0, "array");
        return array[random.nextInt(array.length)];
    }

    public static <T> T random(T[] array) {
        return RandomUtils.random(new Random(), array);
    }

    public static int random(int[] array) {
        return RandomUtils.random(new Random(), array);
    }

    public static long random(long[] array) {
        return RandomUtils.random(new Random(), array);
    }

    public static short random(short[] array) {
        return RandomUtils.random(new Random(), array);
    }

    public static byte random(byte[] array) {
        return RandomUtils.random(new Random(), array);
    }

    public static float random(float[] array) {
        return RandomUtils.random(new Random(), array);
    }

    public static double random(double[] array) {
        return RandomUtils.random(new Random(), array);
    }

    public static char random(char[] array) {
        return RandomUtils.random(new Random(), array);
    }

    public static boolean random(boolean[] array) {
        return RandomUtils.random(new Random(), array);
    }

    public static int[] random(Random random, int[] array, int length) {
        Assert.requiredArgument(random != null, "random");
        Assert.requiredArgument(length > 0, "Length must be greater than 0");
        Assert.requiredArgument(array != null && array.length != 0, "array");
        int[] arr = new int[length];
        int size = array.length;
        for (int i = 0; i < length; ++i) {
            arr[i] = array[random.nextInt(size)];
        }
        return arr;
    }

    public static int[] random(int[] array, int length) {
        return RandomUtils.random(new Random(), array, length);
    }

    public static char[] random(Random random, char[] array, int length) {
        Assert.requiredArgument(random != null, "random");
        Assert.requiredArgument(length > 0, "Length must be greater than 0");
        Assert.requiredArgument(array != null && array.length != 0, "array");
        char[] arr = new char[length];
        int size = array.length;
        for (int i = 0; i < length; ++i) {
            arr[i] = array[random.nextInt(size)];
        }
        return arr;
    }

    public static char[] random(char[] array, int length) {
        return RandomUtils.random(new Random(), array, length);
    }

    public static short[] random(Random random, short[] array, int length) {
        Assert.requiredArgument(random != null, "random");
        Assert.requiredArgument(length > 0, "Length must be greater than 0");
        Assert.requiredArgument(array != null && array.length != 0, "array");
        short[] arr = new short[length];
        int size = array.length;
        for (int i = 0; i < length; ++i) {
            arr[i] = array[random.nextInt(size)];
        }
        return arr;
    }

    public static short[] random(short[] array, int length) {
        return RandomUtils.random(new Random(), array, length);
    }

    public static byte[] random(Random random, byte[] array, int length) {
        Assert.requiredArgument(random != null, "random");
        Assert.requiredArgument(length > 0, "Length must be greater than 0");
        Assert.requiredArgument(array != null && array.length != 0, "array");
        byte[] arr = new byte[length];
        int size = array.length;
        for (int i = 0; i < length; ++i) {
            arr[i] = array[random.nextInt(size)];
        }
        return arr;
    }

    public static byte[] random(byte[] array, int length) {
        return RandomUtils.random(new Random(), array, length);
    }

    public static long[] random(Random random, long[] array, int length) {
        Assert.requiredArgument(random != null, "random");
        Assert.requiredArgument(length > 0, "Length must be greater than 0");
        Assert.requiredArgument(array != null && array.length != 0, "array");
        long[] arr = new long[length];
        int size = array.length;
        for (int i = 0; i < length; ++i) {
            arr[i] = array[random.nextInt(size)];
        }
        return arr;
    }

    public static long[] random(long[] array, int length) {
        return RandomUtils.random(new Random(), array, length);
    }

    public static boolean[] random(Random random, boolean[] array, int length) {
        Assert.requiredArgument(random != null, "random");
        Assert.requiredArgument(length > 0, "Length must be greater than 0");
        Assert.requiredArgument(array != null && array.length != 0, "array");
        boolean[] arr = new boolean[length];
        int size = array.length;
        for (int i = 0; i < length; ++i) {
            arr[i] = array[random.nextInt(size)];
        }
        return arr;
    }

    public static boolean[] random(boolean[] array, int length) {
        return RandomUtils.random(new Random(), array, length);
    }

    public static float[] random(Random random, float[] array, int length) {
        Assert.requiredArgument(random != null, "random");
        Assert.requiredArgument(length > 0, "Length must be greater than 0");
        Assert.requiredArgument(array != null && array.length != 0, "array");
        float[] arr = new float[length];
        int size = array.length;
        for (int i = 0; i < length; ++i) {
            arr[i] = array[random.nextInt(size)];
        }
        return arr;
    }

    public static float[] random(float[] array, int length) {
        return RandomUtils.random(new Random(), array, length);
    }

    public static double[] random(Random random, double[] array, int length) {
        Assert.requiredArgument(random != null, "random");
        Assert.requiredArgument(length > 0, "Length must be greater than 0");
        Assert.requiredArgument(array != null && array.length != 0, "array");
        double[] arr = new double[length];
        int size = array.length;
        for (int i = 0; i < length; ++i) {
            arr[i] = array[random.nextInt(size)];
        }
        return arr;
    }

    public static double[] random(double[] array, int length) {
        return RandomUtils.random(new Random(), array, length);
    }

    public static <T> T[] random(Random random, T[] array, int length) {
        Assert.requiredArgument(random != null, "random");
        Assert.requiredArgument(length > 0, "Length must be greater than 0");
        Assert.requiredArgument(array != null && array.length != 0, "array");
        Object target = Array.newInstance(array.getClass().getComponentType(), length);
        int size = array.length;
        for (int i = 0; i < length; ++i) {
            Array.set(target, i, array[random.nextInt(size)]);
        }
        return (Object[])target;
    }

    public static <T> T[] random(T[] array, int length) {
        return RandomUtils.random(new Random(), array, length);
    }

    public static char[] random(Random random, CharSequence source, int length) {
        Assert.requiredArgument(StringUtils.isEmpty(source), "source");
        Assert.requiredArgument(length > 0, "Length must be greater than 0");
        char[] arr = new char[length];
        int size = source.length();
        for (int i = 0; i < length; ++i) {
            arr[i] = source.charAt(random.nextInt(size));
        }
        return arr;
    }

    public static char[] random(CharSequence source, int length) {
        return RandomUtils.random(new Random(), source, length);
    }

    public static String random(Random random, String source, int length) {
        Assert.requiredArgument(StringUtils.isEmpty(source), "source");
        Assert.requiredArgument(length > 0, "Length must be greater than 0");
        char[] arr = new char[length];
        int size = source.length();
        for (int i = 0; i < length; ++i) {
            arr[i] = source.charAt(random.nextInt(size));
        }
        return new String(arr);
    }

    public static String random(String source, int length) {
        return RandomUtils.random(new Random(), source, length);
    }

    public static String randomString(int length) {
        return new String(RandomUtils.random(ALL, length));
    }

    public static String randomNumCode(int len) {
        return new String(RandomUtils.random(NUMBERIC_CHARACTER, len));
    }

    @Nullable
    public static <T, E extends Throwable> T random(Number totalWeight, Number weight, Iterator<? extends T> iterator, Processor<T, Number, E> weightProcessor, @Nullable Predicate<? super T> removePredicate) throws E {
        Assert.requiredArgument(weightProcessor != null, "weightProcessor");
        Assert.requiredArgument(iterator != null, "iterator");
        Assert.isTrue(totalWeight != null && NumberComparator.INSTANCE.compare(totalWeight, 0) > 0, "totalWeight needs to be greater than 0");
        Assert.isTrue(weight != null && NumberComparator.INSTANCE.compare(weight, 0) > 0, "weight needs to be greater than 0");
        Assert.isTrue(NumberComparator.INSTANCE.compare(weight, totalWeight) <= 0, "weight[" + weight + "] cannot be greater than totalweight[" + totalWeight + "]");
        Number indexWeight = 0;
        while (iterator.hasNext()) {
            int compareValue;
            Number itemWeight;
            T item = iterator.next();
            if (item == null || (itemWeight = weightProcessor.process(item)) == null || (compareValue = NumberComparator.INSTANCE.compare(itemWeight, 0)) == 0) continue;
            if (compareValue < 0) {
                throw new IllegalArgumentException("Weight needs to be greater than 0");
            }
            if (NumberComparator.INSTANCE.compare(weight, indexWeight = Addition.INSTANCE.eval(indexWeight, itemWeight)) > 0) continue;
            if (removePredicate != null && removePredicate.test(item)) {
                iterator.remove();
            }
            return item;
        }
        return null;
    }

    public static <T, E extends Throwable> Number getWeight(Iterator<? extends T> iterator, Processor<T, Number, E> weightProcessor) throws E {
        Assert.requiredArgument(weightProcessor != null, "weightProcessor");
        Assert.requiredArgument(iterator != null, "iterator");
        Number totalWegith = 0;
        while (iterator.hasNext()) {
            int compareValue;
            Number weight;
            T item = iterator.next();
            if (item == null || (weight = weightProcessor.process(item)) == null || (compareValue = NumberComparator.INSTANCE.compare(weight, 0)) == 0) continue;
            if (compareValue < 0) {
                throw new IllegalArgumentException("Weight needs to be greater than 0");
            }
            totalWegith = Addition.INSTANCE.eval(totalWegith, weight);
        }
        return totalWegith;
    }

    public static <T, E extends Throwable> T random(Number totalWeight, Iterator<? extends T> iterator, Processor<T, Number, E> weightProcessor, @Nullable Predicate<? super T> removePredicate) throws E {
        return RandomUtils.random(totalWeight, RandomUtils.random((Number)1, Addition.INSTANCE.eval(totalWeight, 1)), iterator, weightProcessor, removePredicate);
    }

    public static <T, E extends Throwable> T random(Iterable<? extends T> iterable, Processor<T, Number, E> weightProcessor, Processor<Number, Number, E> randomProcessor, @Nullable Predicate<? super T> removePredicate) throws E {
        Assert.requiredArgument(weightProcessor != null, "weightProcessor");
        Assert.requiredArgument(randomProcessor != null, "randomProcessor");
        if (iterable == null) {
            return null;
        }
        Number totalWegith = RandomUtils.getWeight(iterable.iterator(), weightProcessor);
        Number randomWeight = randomProcessor.process(totalWegith);
        if (randomWeight == null) {
            return null;
        }
        return RandomUtils.random(totalWegith, randomWeight, iterable.iterator(), weightProcessor, removePredicate);
    }

    public static <T, E extends Throwable> T random(Iterable<? extends T> iterable, Processor<T, Number, E> weightProcessor, @Nullable Predicate<? super T> removePredicate) throws E {
        return RandomUtils.random(iterable, weightProcessor, (Number e) -> RandomUtils.random((Number)1, Addition.INSTANCE.eval((Number)e, 1)), removePredicate);
    }
}

