/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.util;

import io.basc.framework.util.ClassUtils;
import io.basc.framework.util.DisposableRegistration;
import io.basc.framework.util.MergedRegistration;
import io.basc.framework.util.RegistrationException;

public interface Registration {
    public static final Registration EMPTY = new Registration(){

        @Override
        public void unregister() {
        }

        @Override
        public Registration disposable() {
            return this;
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public Registration and(Registration registration) {
            if (registration == null) {
                return this;
            }
            if (ClassUtils.isLambdaClass(registration.getClass())) {
                return DisposableRegistration.of(registration);
            }
            return registration;
        }
    };

    public void unregister() throws RegistrationException;

    default public boolean isEmpty() {
        return this == EMPTY;
    }

    default public Registration disposable() {
        return DisposableRegistration.of(this);
    }

    default public Registration and(Registration registration) {
        return MergedRegistration.merge(this, registration);
    }
}

