/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.util;

import io.basc.framework.core.reflect.ReflectionUtils;
import io.basc.framework.core.type.classreading.CachingMetadataReaderFactory;
import io.basc.framework.core.type.classreading.MetadataReader;
import io.basc.framework.core.type.classreading.MetadataReaderFactory;
import io.basc.framework.core.type.filter.TypeFilter;
import io.basc.framework.io.Resource;
import io.basc.framework.logger.Logger;
import io.basc.framework.logger.LoggerFactory;
import io.basc.framework.util.Assert;
import io.basc.framework.util.ClassUtils;
import io.basc.framework.util.ClassesLoader;
import io.basc.framework.util.Cursor;
import io.basc.framework.util.DefaultClassLoaderProvider;
import io.basc.framework.util.ResultSet;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;

public class ResourceClassesLoader
extends DefaultClassLoaderProvider
implements ClassesLoader {
    private static Logger logger = LoggerFactory.getLogger(ResourceClassesLoader.class);
    private volatile Set<Class<?>> caching;
    private boolean disableCache = Boolean.getBoolean("classes.loader.cache.disable");
    private volatile MetadataReaderFactory metadataReaderFactory;
    private final ResultSet<Resource> resources;
    private TypeFilter typeFilter;
    private Predicate<? super Class<?>> classFilter;
    private boolean notPerformReflectionVerification = Boolean.getBoolean("perform.reflection.verification.disable");

    public ResourceClassesLoader(ResultSet<Resource> resources) {
        Assert.requiredArgument(resources != null, "resources");
        this.resources = resources;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Class<?>> getCaching() {
        if (this.caching == null) {
            ResourceClassesLoader resourceClassesLoader = this;
            synchronized (resourceClassesLoader) {
                if (this.caching == null) {
                    this.caching = this.load().toSet();
                }
            }
        }
        return this.caching;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MetadataReaderFactory getMetadataReaderFactory() {
        if (this.metadataReaderFactory == null) {
            ResourceClassesLoader resourceClassesLoader = this;
            synchronized (resourceClassesLoader) {
                if (this.metadataReaderFactory == null) {
                    this.metadataReaderFactory = new CachingMetadataReaderFactory(this.getClassLoader());
                }
            }
        }
        return this.metadataReaderFactory;
    }

    public ResultSet<Resource> getResources() {
        return this.resources;
    }

    public TypeFilter getTypeFilter() {
        return this.typeFilter;
    }

    public boolean isDisableCache() {
        return this.disableCache;
    }

    public Predicate<? super Class<?>> getClassFilter() {
        return this.classFilter;
    }

    public void setClassFilter(Predicate<? super Class<?>> classFilter) {
        this.classFilter = classFilter;
    }

    @Override
    public Cursor<Class<?>> iterator() {
        if (this.isDisableCache()) {
            return this.load();
        }
        return Cursor.of(this.getCaching());
    }

    public Cursor<Class<?>> load() {
        Stream<Class> stream = this.resources.stream().map((? super T resource) -> {
            if (resource == null) {
                return null;
            }
            MetadataReaderFactory factory = this.getMetadataReaderFactory();
            try {
                MetadataReader reader = factory.getMetadataReader((Resource)resource);
                if (reader == null) {
                    return null;
                }
                TypeFilter typeFilter = this.getTypeFilter();
                if (typeFilter != null && !typeFilter.match(reader, factory)) {
                    return null;
                }
                Class<?> clazz = ClassUtils.getClass(reader.getClassMetadata().getClassName(), this.getClassLoader());
                if (clazz == null) {
                    return null;
                }
                Predicate<Class<?>> classFilter = this.getClassFilter();
                if (classFilter != null && !classFilter.test(clazz)) {
                    return null;
                }
                if (!this.isNotPerformReflectionVerification() && !ReflectionUtils.isAvailable(clazz, logger)) {
                    return null;
                }
                return clazz;
            }
            catch (Throwable e) {
                logger.error(e, "Failed to load class from resource {}", resource);
                return null;
            }
        });
        return Cursor.of(stream.filter((? super T e) -> e != null));
    }

    public boolean isNotPerformReflectionVerification() {
        return this.notPerformReflectionVerification;
    }

    public void setNotPerformReflectionVerification(boolean notPerformReflectionVerification) {
        this.notPerformReflectionVerification = notPerformReflectionVerification;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reload() {
        if (this.metadataReaderFactory instanceof CachingMetadataReaderFactory) {
            ((CachingMetadataReaderFactory)this.metadataReaderFactory).clearCache();
        }
        if (this.isDisableCache()) {
            ResourceClassesLoader resourceClassesLoader = this;
            synchronized (resourceClassesLoader) {
                this.caching = null;
            }
        }
        if (this.caching != null) {
            ResourceClassesLoader resourceClassesLoader = this;
            synchronized (resourceClassesLoader) {
                if (this.caching != null) {
                    this.caching = this.load().toSet();
                }
            }
        }
    }

    public void setDisableCache(boolean disableCache) {
        this.disableCache = disableCache;
    }

    public void setMetadataReaderFactory(MetadataReaderFactory metadataReaderFactory) {
        this.metadataReaderFactory = metadataReaderFactory;
    }

    public void setTypeFilter(TypeFilter typeFilter) {
        this.typeFilter = typeFilter;
    }
}

