/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.util;

import io.basc.framework.lang.Nullable;
import io.basc.framework.lang.UnsupportedException;
import io.basc.framework.util.Assert;
import io.basc.framework.util.ConsumeProcessor;
import io.basc.framework.util.Processor;
import io.basc.framework.util.ResultSet;
import io.basc.framework.util.Selector;
import java.util.function.Supplier;
import java.util.stream.Stream;

public final class Select<E>
implements Supplier<E> {
    private final ResultSet<E> elements;
    @Nullable
    private final Selector<E> selector;

    public Select(ResultSet<E> elements, @Nullable Selector<E> selector) {
        Assert.requiredArgument(elements != null, "elements");
        this.elements = elements;
        this.selector = selector;
    }

    public ResultSet<E> getElements() {
        return this.elements;
    }

    @Nullable
    public Selector<E> getSelector() {
        return this.selector;
    }

    @Override
    public E get() {
        if (this.selector == null) {
            throw new UnsupportedException("Selector not found");
        }
        return (E)this.elements.export(e -> this.selector.apply((Stream<E>)e));
    }

    public <T, X extends Throwable> T process(Processor<? super E, ? extends T, ? extends X> processor) throws X {
        Assert.requiredArgument(processor != null, "processor");
        if (this.selector == null) {
            throw new UnsupportedException("Selector not found");
        }
        Object element = this.elements.export(e -> this.selector.apply((Stream<E>)e));
        if (element == null) {
            return null;
        }
        return processor.process(element);
    }

    public <X extends Throwable> void consume(ConsumeProcessor<? super E, ? extends X> consumer) throws X {
        Assert.requiredArgument(consumer != null, "consumer");
        if (this.selector == null) {
            this.elements.transfer(e -> ConsumeProcessor.consumeAll(e.iterator(), consumer));
        } else {
            Object element = this.elements.export(e -> this.selector.apply((Stream<E>)e));
            if (element == null) {
                return;
            }
            consumer.process(element);
        }
    }
}

