/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.util;

import io.basc.framework.core.OrderComparator;
import io.basc.framework.factory.support.EmptyServiceLoader;
import io.basc.framework.factory.support.ServiceLoaders;
import io.basc.framework.lang.Nullable;
import io.basc.framework.util.Cursor;
import io.basc.framework.util.ResultSet;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public interface ServiceLoader<S>
extends ResultSet<S> {
    public void reload();

    @Override
    public Cursor<S> iterator();

    @Override
    default public Stream<S> stream() {
        return StreamSupport.stream(this.spliterator(), false).sorted(OrderComparator.INSTANCE);
    }

    @Override
    default public <U> ServiceLoader<U> flatConvert(final Function<? super Stream<S>, ? extends Stream<U>> converter) {
        return new ServiceLoader<U>(){

            @Override
            public void reload() {
                ServiceLoader.this.reload();
            }

            @Override
            public Cursor<U> iterator() {
                return ServiceLoader.this.iterator().flatConvert(converter);
            }
        };
    }

    @Override
    default public <U> ServiceLoader<U> convert(Function<? super S, ? extends U> converter) {
        return this.flatConvert((T e) -> e.map(converter));
    }

    @Override
    default public ServiceLoader<S> filter(Predicate<? super S> predicate) {
        return this.flatConvert((T e) -> e.filter(predicate));
    }

    public static boolean isEmpty(ServiceLoader<?> serviceLoader) {
        return serviceLoader == null || serviceLoader.getClass() == EmptyServiceLoader.class;
    }

    public static <T> ServiceLoader<T> concat(@Nullable ServiceLoader<T> before, @Nullable ServiceLoader<T> after) {
        if (ServiceLoader.isEmpty(before)) {
            if (ServiceLoader.isEmpty(after)) {
                return new EmptyServiceLoader();
            }
            return after;
        }
        if (ServiceLoader.isEmpty(after)) {
            return before;
        }
        return new ServiceLoaders(before, after);
    }
}

