/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.util;

import io.basc.framework.util.CollectionUtils;
import io.basc.framework.util.ConsumeProcessor;
import io.basc.framework.util.Cursor;
import io.basc.framework.util.Processor;
import io.basc.framework.util.Registration;
import io.basc.framework.util.ResultSet;
import io.basc.framework.util.XUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Stream;

public final class SharedResultSet<E>
implements ResultSet<E>,
Serializable {
    private static final long serialVersionUID = 1L;
    private volatile List<E> list;
    private volatile int version;

    public SharedResultSet() {
    }

    public SharedResultSet(Collection<? extends E> list) {
        this.list = new ArrayList<E>(list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Registration register(E element) {
        SharedResultSet sharedResultSet;
        if (this.list == null) {
            sharedResultSet = this;
            synchronized (sharedResultSet) {
                if (this.list == null) {
                    this.list = new ArrayList();
                }
            }
        }
        sharedResultSet = this;
        synchronized (sharedResultSet) {
            if (this.list.contains(element)) {
                return Registration.EMPTY;
            }
            this.list.add(element);
            return new ElementRegistion(element, this.version);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unregister(E element, int version) {
        if (this.list != null && version == this.version) {
            SharedResultSet sharedResultSet = this;
            synchronized (sharedResultSet) {
                if (this.list != null && version == this.version) {
                    this.list.remove(element);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        if (this.list != null) {
            SharedResultSet sharedResultSet = this;
            synchronized (sharedResultSet) {
                if (this.list != null) {
                    this.list.clear();
                    ++this.version;
                }
            }
        }
    }

    @Override
    public Cursor<E> iterator() {
        return Cursor.of(this.list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T, X extends Throwable> T export(Processor<? super Stream<E>, ? extends T, ? extends X> processor) throws X {
        if (!this.isEmpty()) {
            SharedResultSet sharedResultSet = this;
            synchronized (sharedResultSet) {
                if (!this.isEmpty()) {
                    return ResultSet.super.export(processor);
                }
            }
        }
        return processor.process(XUtils.emptyStream());
    }

    public boolean isEmpty() {
        return CollectionUtils.isEmpty(this.list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <X extends Throwable> void transfer(ConsumeProcessor<? super Stream<E>, ? extends X> processor) throws X {
        if (!this.isEmpty()) {
            SharedResultSet sharedResultSet = this;
            synchronized (sharedResultSet) {
                if (!this.isEmpty()) {
                    ResultSet.super.transfer(processor);
                    return;
                }
            }
        }
        processor.process(XUtils.emptyStream());
    }

    private class ElementRegistion
    implements Registration {
        private final E element;
        private int version;
        private AtomicBoolean closed = new AtomicBoolean();

        ElementRegistion(E element, int version) {
            this.element = element;
            this.version = version;
        }

        @Override
        public void unregister() {
            if (this.closed.compareAndSet(false, true)) {
                SharedResultSet.this.unregister(this.element, this.version);
            }
        }

        @Override
        public boolean isEmpty() {
            return this.closed.get() || this.version != SharedResultSet.this.version;
        }
    }
}

