/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.util;

import io.basc.framework.util.StringMatcher;
import io.basc.framework.util.StringMatchers;
import io.basc.framework.util.StringUtils;

public class SplitStringMatcher
implements StringMatcher {
    private final StringMatcher stringMatcher;
    private final String split;

    public SplitStringMatcher(StringMatcher stringMatcher, String split) {
        this.stringMatcher = stringMatcher;
        this.split = split;
    }

    public final StringMatcher getStringMatcher() {
        return this.stringMatcher;
    }

    public final String getSplit() {
        return this.split;
    }

    public String[] splitText(String text) {
        return StringUtils.splitToArray((CharSequence)text, this.split);
    }

    @Override
    public boolean isPattern(String text) {
        if (text == null) {
            return false;
        }
        for (String str : this.splitText(text)) {
            if (this.stringMatcher.isPattern(str)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean match(String pattern, String text) {
        String[] textArray;
        if (pattern == null || text == null) {
            return false;
        }
        String[] patternArray = this.splitText(pattern);
        if (patternArray.length != (textArray = this.splitText(text)).length) {
            return false;
        }
        for (int i = 0; i < patternArray.length; ++i) {
            if (StringMatchers.match(this.stringMatcher, patternArray[i], textArray[i])) continue;
            return false;
        }
        return true;
    }
}

