/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.util;

import io.basc.framework.lang.Nullable;
import io.basc.framework.util.Closer;
import io.basc.framework.util.ConsumeProcessor;
import io.basc.framework.util.RunnableProcessor;
import io.basc.framework.util.StandardCloseable;

public class StandardCloser<T, E extends Throwable, C extends StandardCloser<T, E, C>>
extends StandardCloseable<E, C>
implements Closer<T, E> {
    private ConsumeProcessor<? super T, ? extends E> closeHandler;

    public StandardCloser() {
        this(null, null);
    }

    public StandardCloser(@Nullable RunnableProcessor<? extends E> closeProcessor) {
        this(closeProcessor, null);
    }

    public StandardCloser(@Nullable ConsumeProcessor<? super T, ? extends E> closeHandler) {
        this(null, closeHandler);
    }

    public StandardCloser(@Nullable RunnableProcessor<? extends E> closeProcessor, @Nullable ConsumeProcessor<? super T, ? extends E> closeHandler) {
        super(closeProcessor);
        this.closeHandler = closeHandler;
    }

    @Override
    public void close(T source) throws E {
        if (source != null && this.closeHandler != null) {
            this.closeHandler.process(source);
        }
    }

    public C onClose(ConsumeProcessor<? super T, ? extends E> closeHandler) {
        if (closeHandler == null) {
            return (C)this;
        }
        if (this.closeHandler == null) {
            this.closeHandler = closeHandler;
        } else {
            ConsumeProcessor old = this.closeHandler;
            this.closeHandler = t -> {
                try {
                    old.process((Object)t);
                }
                finally {
                    closeHandler.process(t);
                }
            };
        }
        return (C)this;
    }
}

