/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.util;

import io.basc.framework.lang.Nullable;
import io.basc.framework.util.Assert;
import io.basc.framework.util.Return;
import io.basc.framework.util.StandardStatus;
import io.basc.framework.util.Status;
import java.util.NoSuchElementException;
import java.util.function.Function;

public class StandardReturn<T>
extends StandardStatus
implements Return<T> {
    private static final long serialVersionUID = 1L;
    protected final T value;

    public StandardReturn(boolean success, long code, @Nullable String description, @Nullable T value) {
        super(success, code, description);
        this.value = value;
    }

    public StandardReturn(Status status, @Nullable T value) {
        super(status);
        this.value = value;
    }

    public StandardReturn(Return<T> rtn) {
        super(rtn);
        if (rtn instanceof StandardReturn) {
            StandardReturn defaultReturn = (StandardReturn)rtn;
            this.value = defaultReturn.value;
        } else {
            this.value = rtn.get();
        }
    }

    @Override
    public T get() {
        if (this.value == null) {
            String msg = this.getMsg();
            if (msg == null) {
                msg = "No value present";
            }
            throw new NoSuchElementException(msg);
        }
        return this.value;
    }

    @Override
    public boolean isPresent() {
        return this.value != null;
    }

    @Override
    public <U> Return<U> convert(Function<? super T, ? extends U> converter) {
        Assert.requiredArgument(converter != null, "converter");
        U u = converter.apply(this.value);
        return new StandardReturn<U>(this, u);
    }
}

