/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.util;

import io.basc.framework.lang.Nullable;
import io.basc.framework.util.ConsumeProcessor;
import io.basc.framework.util.Processor;
import io.basc.framework.util.RunnableProcessor;
import io.basc.framework.util.Source;
import io.basc.framework.util.StandardCloser;
import io.basc.framework.util.StreamOperations;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;

public class StandardStreamOperations<T, E extends Throwable, C extends StandardStreamOperations<T, E, C>>
extends StandardCloser<T, E, C>
implements StreamOperations<T, E> {
    private final Processor<? super C, ? extends T, ? extends E> sourceProcesor;
    private List<ConsumeProcessor<? super T, ? extends E>> consumers;
    private Supplier<? extends String> toString;

    public StandardStreamOperations(Source<? extends T, ? extends E> source) {
        this(source, null, null);
    }

    public StandardStreamOperations(final Source<? extends T, ? extends E> source, @Nullable ConsumeProcessor<? super T, ? extends E> closeProcessor, @Nullable RunnableProcessor<? extends E> closeHandler) {
        this(new Processor<C, T, E>(){

            @Override
            public T process(C operations) throws Throwable {
                return source.get();
            }

            public String toString() {
                return source.toString();
            }
        }, closeProcessor, closeHandler);
    }

    public StandardStreamOperations(Processor<? super C, ? extends T, ? extends E> sourceProcesor) {
        this(sourceProcesor, null, null);
    }

    public StandardStreamOperations(Processor<? super C, ? extends T, ? extends E> sourceProcesor, @Nullable ConsumeProcessor<? super T, ? extends E> closeProcessor, @Nullable RunnableProcessor<? extends E> closeHandler) {
        super(closeHandler, closeProcessor);
        this.sourceProcesor = sourceProcesor;
    }

    public <S> StandardStreamOperations(final StreamOperations<S, ? extends E> sourceStreamOperations, final Processor<? super S, ? extends T, ? extends E> processor, @Nullable ConsumeProcessor<? super T, ? extends E> closeProcessor, @Nullable RunnableProcessor<? extends E> closeHandler) {
        this(new Processor<C, T, E>(){

            @Override
            public T process(C operations) throws Throwable {
                Object source = sourceStreamOperations.get();
                try {
                    Object t = processor.process(source);
                    return t;
                }
                catch (Throwable e) {
                    sourceStreamOperations.close(source);
                    throw e;
                }
                finally {
                    ((StandardStreamOperations)((StandardStreamOperations)operations).onClose(() -> sourceStreamOperations.close(source))).onClose(() -> sourceStreamOperations.close());
                }
            }

            public String toString() {
                return sourceStreamOperations.toString();
            }
        }, closeProcessor, closeHandler);
    }

    @Override
    public C onClose(ConsumeProcessor<? super T, ? extends E> closeHandler) {
        return (C)((StandardStreamOperations)super.onClose((ConsumeProcessor)closeHandler));
    }

    @Override
    public C onClose(RunnableProcessor<? extends E> closeHandler) {
        return (C)((StandardStreamOperations)super.onClose(closeHandler));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T get() throws E {
        T target = this.sourceProcesor.process(this);
        if (this.consumers != null) {
            try {
                for (ConsumeProcessor<T, E> consumer : this.consumers) {
                    consumer.process(target);
                }
            }
            catch (Throwable e) {
                try {
                    this.close(target);
                }
                finally {
                    this.close();
                }
                throw e;
            }
        }
        return target;
    }

    public C after(ConsumeProcessor<? super T, ? extends E> consumer) {
        if (this.consumers == null) {
            this.consumers = new ArrayList<ConsumeProcessor<? super T, ? extends E>>();
        }
        this.consumers.add(consumer);
        return (C)this;
    }

    public void setToString(Supplier<? extends String> toString) {
        this.toString = toString;
    }

    public String toString() {
        return this.toString == null ? this.sourceProcesor.toString() : this.toString.toString();
    }
}

