/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.util;

import io.basc.framework.lang.Nullable;
import io.basc.framework.util.AbstractStreamOptional;
import io.basc.framework.util.ConsumeProcessor;
import io.basc.framework.util.RunnableProcessor;
import io.basc.framework.util.Source;
import io.basc.framework.util.StreamOptional;
import java.util.NoSuchElementException;
import java.util.function.Function;

public class StandardStreamOptional<T>
extends AbstractStreamOptional<T, StandardStreamOptional<T>>
implements StreamOptional<T> {
    private final Source<? extends T, ? extends RuntimeException> source;

    public StandardStreamOptional(Source<? extends T, ? extends RuntimeException> source) {
        this(source, null);
    }

    public StandardStreamOptional(Source<? extends T, ? extends RuntimeException> source, @Nullable RunnableProcessor<? extends RuntimeException> closeHandler) {
        this(source, null, closeHandler);
    }

    public StandardStreamOptional(Source<? extends T, ? extends RuntimeException> source, @Nullable ConsumeProcessor<? super T, ? extends RuntimeException> closeProcessor, @Nullable RunnableProcessor<? extends RuntimeException> closeHandler) {
        super(closeHandler, closeProcessor);
        this.source = source;
    }

    @Override
    public T get() {
        T value = this.source.get();
        if (value == null) {
            throw new NoSuchElementException("No value present");
        }
        return value;
    }

    @Override
    public boolean isPresent() {
        return this.source.get() != null;
    }

    @Override
    public <U> StreamOptional<U> convert(Function<? super T, ? extends U> converter) {
        return new StandardStreamOptional<Object>(() -> converter.apply((T)this.source.get()));
    }
}

