/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.util;

import io.basc.framework.util.Closeable;
import io.basc.framework.util.ConsumeProcessor;
import io.basc.framework.util.Processor;
import io.basc.framework.util.RunnableProcessor;
import io.basc.framework.util.Source;
import io.basc.framework.util.StandardStreamOperations;
import io.basc.framework.util.StreamSource;

public interface StreamOperations<T, E extends Throwable>
extends StreamSource<T, E>,
Closeable<E> {
    public static <R, X extends Throwable> StreamOperations<R, X> of(Source<? extends R, ? extends X> source) {
        if (source instanceof StreamOperations) {
            return (StreamOperations)source;
        }
        return new StandardStreamOperations(source);
    }

    @Override
    default public <X extends Throwable> void consume(ConsumeProcessor<? super T, ? extends X> processor) throws E, X {
        try {
            StreamSource.super.consume(processor);
        }
        finally {
            this.close();
        }
    }

    @Override
    public StreamOperations<T, E> onClose(ConsumeProcessor<? super T, ? extends E> var1);

    public StreamOperations<T, E> onClose(RunnableProcessor<? extends E> var1);

    @Override
    default public <R, X extends Throwable> R process(Processor<? super T, ? extends R, ? extends X> processor) throws E, X {
        try {
            R r = StreamSource.super.process(processor);
            return r;
        }
        finally {
            this.close();
        }
    }

    @Override
    default public <R> StreamOperations<R, E> stream(Processor<? super T, ? extends R, ? extends E> mapper) {
        return new StandardStreamOperations(this, mapper, null, null);
    }
}

