/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.util;

import io.basc.framework.util.ConsumeProcessor;
import io.basc.framework.util.Optional;
import io.basc.framework.util.Processor;
import io.basc.framework.util.RunnableProcessor;
import io.basc.framework.util.Source;
import io.basc.framework.util.StandardStreamOptional;
import io.basc.framework.util.StreamOperations;
import java.util.function.Function;
import java.util.function.Predicate;

public interface StreamOptional<T>
extends Optional<T>,
AutoCloseable,
StreamOperations<T, RuntimeException> {
    @Override
    public void close();

    @Override
    public boolean isClosed();

    @Override
    public <U> StreamOptional<U> convert(Function<? super T, ? extends U> var1);

    @Override
    default public <U> StreamOptional<U> map(Function<? super T, ? extends U> mapper) {
        return this.convert((T e) -> e == null ? null : mapper.apply(e));
    }

    @Override
    default public StreamOptional<T> filter(Predicate<? super T> predicate) {
        return this.convert((T e) -> e != null && predicate.test(e) ? e : null);
    }

    public StreamOptional<T> onClose(ConsumeProcessor<? super T, ? extends RuntimeException> var1);

    @Override
    public StreamOptional<T> onClose(RunnableProcessor<? extends RuntimeException> var1);

    default public <R> StreamOptional<R> stream(Processor<? super T, ? extends R, ? extends RuntimeException> mapper) {
        StreamOptional<Object> stream = StreamOptional.of(() -> this.process(mapper));
        return stream.onClose(() -> this.close());
    }

    public static <R> StreamOptional<R> of(Source<? extends R, ? extends RuntimeException> source) {
        if (source instanceof StreamOptional) {
            return (StreamOptional)source;
        }
        return new StandardStreamOptional<R>(source);
    }
}

