/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.util;

import io.basc.framework.util.Closer;
import io.basc.framework.util.ConsumeProcessor;
import io.basc.framework.util.Processor;
import io.basc.framework.util.StandardStreamProcessor;

public interface StreamProcessor<S, T, E extends Throwable>
extends Processor<S, T, E>,
Closer<T, E> {
    @Override
    default public <V> StreamProcessor<S, V, E> andThen(Processor<? super T, ? extends V, ? extends E> after) {
        return StreamProcessor.of((? super A source) -> {
            Object s = this.process(source);
            try {
                Object t = after.process((T)s);
                return t;
            }
            finally {
                if (s != null && s != source) {
                    this.close(s);
                }
            }
        });
    }

    public StreamProcessor<S, T, E> onClose(ConsumeProcessor<? super T, ? extends E> var1);

    public static <A, B, X extends Throwable> StreamProcessor<A, B, X> of(Processor<? super A, ? extends B, ? extends X> processor) {
        if (processor instanceof StreamProcessor) {
            return (StreamProcessor)processor;
        }
        return new StandardStreamProcessor(processor);
    }
}

