/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.util;

import io.basc.framework.util.Closer;
import io.basc.framework.util.ConsumeProcessor;
import io.basc.framework.util.Processor;
import io.basc.framework.util.Source;
import io.basc.framework.util.StandardStreamSource;

public interface StreamSource<T, E extends Throwable>
extends Source<T, E>,
Closer<T, E> {
    @Override
    public T get() throws E;

    @Override
    public StreamSource<T, E> onClose(ConsumeProcessor<? super T, ? extends E> var1);

    default public <R> StreamSource<R, E> stream(Processor<? super T, ? extends R, ? extends E> mapper) {
        return StreamSource.of(() -> this.process(mapper));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public <R, X extends Throwable> R process(Processor<? super T, ? extends R, ? extends X> processor) throws E, X {
        T source = this.get();
        try {
            R r = processor.process(source);
            return r;
        }
        finally {
            this.close(source);
        }
    }

    default public <X extends Throwable> void consume(ConsumeProcessor<? super T, ? extends X> processor) throws E, X {
        T source = this.get();
        try {
            processor.process(source);
        }
        finally {
            this.close(source);
        }
    }

    public static <R, X extends Throwable> StreamSource<R, X> of(Source<? extends R, ? extends X> source) {
        if (source instanceof StreamSource) {
            return (StreamSource)source;
        }
        return new StandardStreamSource(source);
    }
}

