/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.util;

import io.basc.framework.lang.Nullable;
import io.basc.framework.util.StringMatcher;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;

public final class StringStrategy<T> {
    private TreeMap<String, T> strategyMap;
    private final StringMatcher matcher;
    private final StringStrategy<T> parent;

    public StringStrategy(StringMatcher matcher) {
        this(matcher, null);
    }

    public StringStrategy(StringMatcher matcher, @Nullable StringStrategy<T> parent) {
        this.matcher = matcher;
        this.parent = parent;
    }

    public StringMatcher getMatcher() {
        return this.matcher;
    }

    public void register(String pattern, T value) {
        if (this.strategyMap == null) {
            this.strategyMap = new TreeMap(this.matcher);
        }
        this.strategyMap.put(pattern, value);
    }

    public void unregister(String pattern) {
        if (this.strategyMap == null) {
            return;
        }
        this.strategyMap.remove(pattern);
    }

    public Optional<T> get(String pattern) {
        T value;
        if (this.strategyMap == null) {
            return this.parent == null ? Optional.empty() : this.parent.get(pattern);
        }
        if (this.matcher != null && this.matcher.isPattern(pattern)) {
            for (Map.Entry<String, T> entry : this.strategyMap.entrySet()) {
                if (!this.matcher.match(entry.getKey(), pattern) || entry.getValue() == null) continue;
                return Optional.of(entry.getValue());
            }
        }
        if ((value = this.strategyMap.get(pattern)) != null) {
            return Optional.of(value);
        }
        return this.parent == null ? Optional.empty() : this.parent.get(pattern);
    }

    public boolean isEmpty() {
        return !(this.strategyMap != null && !this.strategyMap.isEmpty() || this.parent != null && !this.parent.isEmpty());
    }
}

