/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.util;

import io.basc.framework.util.StringUtils;
import java.util.function.Function;

public class StringToCharacter
implements Function<String, Character> {
    public static final StringToCharacter DEFAULT = new StringToCharacter(0, '\u0000');
    private final int index;
    private final char defaultValue;

    public StringToCharacter(int index, char defaultValue) {
        this.index = index;
        this.defaultValue = defaultValue;
    }

    public int getIndex() {
        return this.index;
    }

    public char getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public Character apply(String source) {
        if (StringUtils.isEmpty(source)) {
            return null;
        }
        return Character.valueOf(source.charAt(this.index));
    }

    public char applyAsChar(String source) {
        Character value = this.apply(source);
        return value == null ? this.defaultValue : value.charValue();
    }
}

