/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.util;

import io.basc.framework.util.StringToNumber;
import io.basc.framework.util.StringUtils;
import java.util.function.ToIntFunction;

public class StringToInteger
extends StringToNumber
implements ToIntFunction<String> {
    public static final StringToInteger DEFAULT = new StringToInteger(false, 10, 0);
    private final int defaultValue;

    public StringToInteger(boolean unsigned, int radix, int defaultValue) {
        super(unsigned, radix);
        this.defaultValue = defaultValue;
    }

    public int getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public Integer apply(String source) {
        String value = this.format(source);
        if (StringUtils.isEmpty(value)) {
            return null;
        }
        return this.isUnsigned() ? Integer.parseUnsignedInt(value, this.getRadix()) : Integer.valueOf(value, this.getRadix());
    }

    @Override
    public int applyAsInt(String source) {
        Integer value = this.apply(source);
        return value == null ? this.defaultValue : value;
    }
}

