/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.util;

import io.basc.framework.util.Assert;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;

public final class Synchronized
implements InvocationHandler,
Serializable {
    private static final long serialVersionUID = 1L;
    private final Object mutex;
    private final Object source;

    private Synchronized(Object source, Object mutex) {
        Assert.requiredArgument(source != null, "source");
        Assert.requiredArgument(mutex != null, "mutex");
        this.mutex = mutex;
        this.source = source;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Object object = this.mutex;
        synchronized (object) {
            return method.invoke(this.source, args);
        }
    }

    public static <T> T proxy(T source, Object mutex) {
        return (T)Proxy.newProxyInstance(source.getClass().getClassLoader(), source.getClass().getInterfaces(), (InvocationHandler)new Synchronized(source, mutex));
    }
}

