/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.util;

import io.basc.framework.codec.DecodeException;
import io.basc.framework.codec.Decoder;
import io.basc.framework.codec.support.DateCodec;
import io.basc.framework.convert.ConversionException;
import io.basc.framework.lang.Nullable;
import io.basc.framework.util.ArrayUtils;
import io.basc.framework.util.Assert;
import io.basc.framework.util.StringUtils;
import java.text.DateFormatSymbols;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class TimeUtils
extends DateCodec {
    public static final TimeUtils YEAR = new TimeUtils(6, "yyyy");
    public static final TimeUtils MONTH = new TimeUtils(5, "yyyy-MM");
    public static final TimeUtils WEEK = new TimeUtils(7, "yyyy-MM-dd E");
    public static final TimeUtils DAY = new TimeUtils(11, "yyyy-MM-dd");
    public static final TimeUtils HOUR = new TimeUtils(12, "yyyy-MM-dd HH");
    public static final TimeUtils MINUTE = new TimeUtils(13, "yyyy-MM-dd HH:mm");
    public static final TimeUtils SECOND = new TimeUtils(14, "yyyy-MM-dd HH:mm:ss");
    public static final TimeUtils MILLISECOND = new TimeUtils(-1, "yyyy-MM-dd HH:mm:ss,SSS");
    public static final TimeUtils DATE = new TimeUtils(-1, "EEE MMM dd HH:mm:ss zzz yyyy", null, Locale.US, null);
    private final int field;

    public TimeUtils(int field, String pattern) {
        super(pattern);
        this.field = field;
    }

    public TimeUtils(int field, String pattern, TimeZone timeZone, Locale locale, DateFormatSymbols dateFormatSymbols) {
        super(pattern, timeZone, locale, dateFormatSymbols);
        this.field = field;
    }

    public int getField() {
        return this.field;
    }

    public void setMin(Calendar calendar) {
        TimeUtils.setTimeBoundary(calendar, this.field, true);
    }

    public void setMax(Calendar calendar) {
        TimeUtils.setTimeBoundary(calendar, this.field, false);
    }

    public Calendar getMinCalendar(long source) {
        Calendar calendar = TimeUtils.getCalendar(this.getTimeZone(), this.getLocale());
        calendar.setTimeInMillis(source);
        this.setMin(calendar);
        return calendar;
    }

    public Calendar getMaxCalendar(long source) {
        Calendar calendar = TimeUtils.getCalendar(this.getTimeZone(), this.getLocale());
        calendar.setTimeInMillis(source);
        this.setMax(calendar);
        return calendar;
    }

    public Date getMinDate(long source) {
        return this.getMinCalendar(source).getTime();
    }

    public Date getMaxDate(long source) {
        return this.getMaxCalendar(source).getTime();
    }

    public long getMinTime(long source) {
        return this.getMinDate(source).getTime();
    }

    public long getMaxTime(long source) {
        return this.getMinDate(source).getTime();
    }

    public Calendar getMinCalendar() {
        Calendar calendar = TimeUtils.getCalendar(this.getTimeZone(), this.getLocale());
        this.setMin(calendar);
        return calendar;
    }

    public Calendar getMaxCalendar() {
        Calendar calendar = TimeUtils.getCalendar(this.getTimeZone(), this.getLocale());
        this.setMax(calendar);
        return calendar;
    }

    public Date getMinDate() {
        return this.getMinCalendar().getTime();
    }

    public Date getMaxDate() {
        return this.getMaxCalendar().getTime();
    }

    public long getMinTime() {
        return this.getMinDate().getTime();
    }

    public long getMaxTime() {
        return this.getMinDate().getTime();
    }

    public static Calendar getCalendar(@Nullable TimeZone zone, @Nullable Locale locale) {
        if (zone == null) {
            if (locale == null) {
                return Calendar.getInstance();
            }
            return Calendar.getInstance(locale);
        }
        if (locale == null) {
            return Calendar.getInstance(zone);
        }
        return Calendar.getInstance(zone, locale);
    }

    public static Date convert(String source) {
        return TimeUtils.convert(source, new Decoder[0]);
    }

    @SafeVarargs
    public static Date convert(String source, Decoder<String, ? extends Date> ... decoders) {
        if (decoders == null || decoders.length == 0) {
            return TimeUtils.convert(source, DATE, MILLISECOND, SECOND, MINUTE, HOUR, DAY, WEEK, MONTH, YEAR);
        }
        if (decoders.length == 1) {
            return decoders[0].decode(source);
        }
        DecodeException error = null;
        for (Decoder<String, ? extends Date> decoder : decoders) {
            try {
                return decoder.decode(source);
            }
            catch (DecodeException e) {
                if (error == null) {
                    error = e;
                    continue;
                }
                error.addSuppressed(e);
            }
        }
        throw new DecodeException(source, error);
    }

    public static Date parse(String source, String ... patterns) throws ConversionException {
        return TimeUtils.parse(source, null, null, patterns);
    }

    public static Date parse(String source, @Nullable TimeZone timeZone, @Nullable Locale locale, String ... patterns) throws DecodeException {
        if (StringUtils.isEmpty(source)) {
            return null;
        }
        if (ArrayUtils.isEmpty(patterns)) {
            return TimeUtils.convert(source);
        }
        if (patterns.length == 1) {
            return new DateCodec(patterns[0], timeZone, locale, null).decode(source);
        }
        DecodeException error = null;
        for (String pattern : patterns) {
            try {
                return new DateCodec(pattern, timeZone, locale, null).decode(source);
            }
            catch (DecodeException e) {
                if (error == null) {
                    error = e;
                    continue;
                }
                error.addSuppressed(e);
            }
        }
        throw new ConversionException("source=" + source + ", patterns=" + Arrays.toString(patterns), error);
    }

    public static String format(Date source, String pattern) {
        return TimeUtils.format(source, null, null, pattern);
    }

    public static String format(Date source, @Nullable TimeZone zone, @Nullable Locale locale, String pattern) {
        if (source == null) {
            return null;
        }
        return new DateCodec(pattern, zone, locale, null).encode(source);
    }

    public static String format(long source, String pattern) {
        Date d = new Date();
        d.setTime(source);
        return TimeUtils.format(d, pattern);
    }

    public static String format(long source, @Nullable TimeZone zone, @Nullable Locale locale, String pattern) {
        Date d = new Date();
        d.setTime(source);
        return TimeUtils.format(d, zone, locale, pattern);
    }

    public static long getTime(String source, String ... patterns) throws ConversionException {
        return TimeUtils.getTime(source, null, null, patterns);
    }

    public static long getTime(String source, @Nullable TimeZone zone, @Nullable Locale locale, String ... patterns) {
        Date date = TimeUtils.parse(source, zone, locale, patterns);
        return date == null ? 0L : date.getTime();
    }

    public static TimeZone parseTimeZoneString(String timeZoneString) {
        TimeZone timeZone = TimeZone.getTimeZone(timeZoneString);
        if ("GMT".equals(timeZone.getID()) && !timeZoneString.startsWith("GMT")) {
            throw new IllegalArgumentException("Invalid time zone specification '" + timeZoneString + "'");
        }
        return timeZone;
    }

    public static Instant toInstant(LocalDateTime localDateTime) {
        Assert.requiredArgument(localDateTime != null, "localDateTime");
        return localDateTime.toInstant(OffsetDateTime.now().getOffset());
    }

    public static void setTimeBoundary(Calendar calendar, int field, boolean min) {
        if (field < 0) {
            return;
        }
        Assert.isTrue(field <= 14, "field needs to be less than Calendar#MILLISECOND");
        for (int i = 14; i >= field && i >= 12; --i) {
            TimeUtils.setTimeBoundaryActual(calendar, i, min);
        }
        if (field <= 8) {
            TimeUtils.setTimeBoundaryActual(calendar, 11, min);
        }
        if (field <= 2) {
            TimeUtils.setTimeBoundaryActual(calendar, 5, min);
        }
        if (field <= 1) {
            TimeUtils.setTimeBoundaryActual(calendar, 2, min);
        }
        if (field < 12) {
            TimeUtils.setTimeBoundaryActual(calendar, field, min);
        }
    }

    private static void setTimeBoundaryActual(Calendar calendar, int field, boolean min) {
        calendar.set(field, min ? calendar.getActualMinimum(field) : calendar.getActualMaximum(field));
    }

    public static long getTodayBeginTime() {
        return DAY.getMinTime();
    }

    public static boolean isToday(long source) {
        return DAY.contains(System.currentTimeMillis(), source);
    }
}

