/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.util;

import io.basc.framework.util.Assert;
import java.util.AbstractList;

public class UnsafeArrayList<E>
extends AbstractList<E> {
    private final E[] array;

    public UnsafeArrayList(E[] array) {
        Assert.requiredArgument(array != null, "array");
        this.array = array;
    }

    @Override
    public E get(int index) {
        return this.array[index];
    }

    @Override
    public E set(int index, E element) {
        E old = this.array[index];
        this.array[index] = element;
        return old;
    }

    @Override
    public int size() {
        return this.array.length;
    }

    @Override
    public Object[] toArray() {
        return this.array;
    }

    @Override
    public <T> T[] toArray(T[] a) {
        if (this.array.length == 0) {
            return a;
        }
        if (this.array.length > a.length && a.getClass().getComponentType() == this.array.getClass().getComponentType()) {
            return this.array;
        }
        return super.toArray(a);
    }
}

