/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.util;

import io.basc.framework.util.Assert;
import io.basc.framework.util.StringUtils;
import io.basc.framework.value.Value;
import java.io.Serializable;
import java.util.Comparator;

public class Version
implements Serializable,
Comparable<Version>,
Comparator<Value> {
    private static final long serialVersionUID = 1L;
    public static final String DIVIDEERS = ".";
    private final Value[] fragments;
    private final String dividers;

    public Version(String version) {
        this(version, DIVIDEERS);
    }

    public Version(String version, String dividers) {
        Assert.requiredArgument(version != null, "version");
        this.dividers = dividers;
        String[] arr = StringUtils.splitToArray((CharSequence)version, dividers);
        this.fragments = new Value[arr.length];
        for (int i = 0; i < arr.length; ++i) {
            this.fragments[i] = Value.of(arr[i]);
        }
    }

    public Version(Value[] fragments, String dividers) {
        this.fragments = fragments;
        this.dividers = dividers;
    }

    public String getDividers() {
        return this.dividers;
    }

    public Value[] getFragments() {
        return (Value[])this.fragments.clone();
    }

    public int length() {
        return this.fragments.length;
    }

    public Value get(int index) {
        return this.fragments[index];
    }

    @Override
    public int compareTo(Value[] fragments) {
        for (int i = 0; i < fragments.length && i < this.fragments.length; ++i) {
            Value fragment1 = this.fragments[i];
            Value fragment2 = fragments[i];
            int compare = this.compare(fragment1, fragment2);
            if (compare == 0) continue;
            return compare;
        }
        return 0;
    }

    @Override
    public int compareTo(Version o) {
        int compare = this.compareTo(o.fragments);
        if (compare != 0) {
            return compare;
        }
        if (this.fragments.length == o.fragments.length) {
            return 0;
        }
        if (this.fragments.length > o.fragments.length) {
            return 1;
        }
        return -1;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.fragments.length; ++i) {
            if (i != 0) {
                sb.append(this.dividers);
            }
            sb.append(this.fragments[i].getAsString());
        }
        return sb.toString();
    }

    public int hashCode() {
        int hash = 0;
        for (int i = 0; i < this.fragments.length; ++i) {
            hash += this.fragments[i].hashCode();
        }
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj instanceof Version) {
            if (((Version)obj).length() != this.length()) {
                return false;
            }
            for (int i = 0; i < this.fragments.length; ++i) {
                if (this.fragments[i].equals(((Version)obj).fragments[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static Version valueOf(String version) {
        return new Version(version);
    }

    @Override
    public int compare(Value v1, Value v2) {
        if (v1.isNumber() && v2.isNumber()) {
            return Double.compare(v1.getAsDouble(), v2.getAsDouble());
        }
        return v1.getAsString().compareTo(v2.getAsString());
    }
}

