/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.util.alias;

import io.basc.framework.lang.Nullable;
import io.basc.framework.util.ArrayUtils;
import io.basc.framework.util.Assert;
import io.basc.framework.util.StringUtils;
import io.basc.framework.util.alias.AliasFactory;
import io.basc.framework.util.alias.AliasRegistry;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class DefaultAliasRegistry
implements AliasRegistry,
Cloneable {
    private final Map<String, Set<String>> aliasMap;
    private AliasFactory parentAliasFactory;

    public DefaultAliasRegistry() {
        this(new ConcurrentHashMap<String, Set<String>>());
    }

    public DefaultAliasRegistry(Map<String, Set<String>> aliasMap) {
        Assert.requiredArgument(aliasMap != null, "aliasMap");
        this.aliasMap = aliasMap;
    }

    @Nullable
    public AliasFactory getParentAliasFactory() {
        return this.parentAliasFactory;
    }

    public void setParentAliasFactory(AliasFactory parentAliasFactory) {
        this.parentAliasFactory = parentAliasFactory;
    }

    @Override
    public void registerAlias(String name, String alias) {
        Assert.hasText(name, "'name' must not be empty");
        Assert.hasText(alias, "'alias' must not be empty");
        Assert.requiredArgument(!this.hasAlias(name, alias), "name[" + name + "] -> alias[" + alias + "]");
        this.register(name, alias);
        this.register(alias, name);
    }

    private void register(String name, String alias) {
        Set<String> names = this.aliasMap.get(name);
        if (names == null) {
            names = Collections.synchronizedSet(new HashSet());
            Set<String> sets = this.aliasMap.putIfAbsent(name, names);
            if (sets != null) {
                names = sets;
            }
        } else if (names.contains(alias)) {
            throw new IllegalStateException("Cannot register alias '" + alias + "' for name '" + name + "'");
        }
        names.add(alias);
    }

    @Override
    public final boolean isAlias(String name) {
        return this.isAlias(name, this.getParentAliasFactory());
    }

    public boolean isAlias(String name, AliasFactory parent) {
        return this.aliasMap.containsKey(name) || parent != null && parent.isAlias(name);
    }

    @Override
    public final boolean hasAlias(String name, String alias) {
        return this.hasAlias(name, alias, this.getParentAliasFactory());
    }

    public boolean hasAlias(String name, String alias, AliasFactory parent) {
        Set<String> aliases = this.aliasMap.get(name);
        if (aliases == null) {
            return parent == null ? false : parent.hasAlias(name, alias);
        }
        return aliases.contains(alias) || parent != null && parent.hasAlias(name, alias);
    }

    @Override
    public final String[] getAliases(String name) {
        return this.getAliases(name, this.getParentAliasFactory());
    }

    public String[] getAliases(String name, AliasFactory parent) {
        Set<String> names = this.aliasMap.get(name);
        if (names == null) {
            return parent == null ? StringUtils.EMPTY_ARRAY : parent.getAliases(name);
        }
        String[] array = names.toArray(new String[0]);
        return parent == null ? array : ArrayUtils.merge(array, parent.getAliases(name));
    }
}

