/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.util.comparator;

import io.basc.framework.lang.UnsupportedException;
import io.basc.framework.util.comparator.CompareUtils;
import java.io.File;
import java.util.Comparator;

public enum FileComparator implements Comparator<File>
{
    SYSTEM,
    SIZE,
    TYPE,
    NAME,
    LAST_MODIFIED;


    @Override
    public int compare(File o1, File o2) {
        switch (this) {
            case SYSTEM: {
                return o1.compareTo(o2);
            }
            case NAME: {
                return o1.getName().compareTo(o2.getName());
            }
            case TYPE: {
                if (o1.isDirectory() && o2.isDirectory()) {
                    return 0;
                }
                if (o1.isDirectory()) {
                    return 1;
                }
                if (o2.isDirectory()) {
                    return -1;
                }
                return 0;
            }
            case SIZE: {
                return CompareUtils.compare(o1.length(), o2.length(), true);
            }
            case LAST_MODIFIED: {
                return CompareUtils.compare(o1.lastModified(), o2.lastModified(), true);
            }
        }
        throw new UnsupportedException(this.name());
    }
}

