/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.util.concurrent;

import io.basc.framework.lang.RequiredJavaVersion;
import io.basc.framework.util.concurrent.FailureCallback;
import io.basc.framework.util.concurrent.ListenableFuture;
import io.basc.framework.util.concurrent.ListenableFutureCallback;
import io.basc.framework.util.concurrent.ListenableFutureCallbackRegistry;
import io.basc.framework.util.concurrent.SuccessCallback;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.BiFunction;

@RequiredJavaVersion(value=8)
public class CompletableToListenableFutureAdapter<T>
implements ListenableFuture<T> {
    private final CompletableFuture<T> completableFuture;
    private final ListenableFutureCallbackRegistry<T> callbacks = new ListenableFutureCallbackRegistry();

    public CompletableToListenableFutureAdapter(CompletionStage<T> completionStage) {
        this(completionStage.toCompletableFuture());
    }

    public CompletableToListenableFutureAdapter(CompletableFuture<T> completableFuture) {
        this.completableFuture = completableFuture;
        this.completableFuture.handle(new BiFunction<T, Throwable, Object>(){

            @Override
            public Object apply(T result, Throwable ex) {
                if (ex != null) {
                    CompletableToListenableFutureAdapter.this.callbacks.failure(ex);
                } else {
                    CompletableToListenableFutureAdapter.this.callbacks.success(result);
                }
                return null;
            }
        });
    }

    @Override
    public void addCallback(ListenableFutureCallback<? super T> callback) {
        this.callbacks.addCallback(callback);
    }

    @Override
    public void addCallback(SuccessCallback<? super T> successCallback, FailureCallback failureCallback) {
        if (successCallback != null) {
            this.callbacks.addSuccessCallback(successCallback);
        }
        if (failureCallback != null) {
            this.callbacks.addFailureCallback(failureCallback);
        }
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return this.completableFuture.cancel(mayInterruptIfRunning);
    }

    @Override
    public boolean isCancelled() {
        return this.completableFuture.isCancelled();
    }

    @Override
    public boolean isDone() {
        return this.completableFuture.isDone();
    }

    @Override
    public T get() throws InterruptedException, ExecutionException {
        return this.completableFuture.get();
    }

    @Override
    public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.completableFuture.get(timeout, unit);
    }
}

