/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.util.concurrent;

import io.basc.framework.util.concurrent.AsyncExecutor;
import io.basc.framework.util.concurrent.ListenableFutureTask;
import io.basc.framework.util.concurrent.ScheduledListenableFuture;
import io.basc.framework.util.concurrent.ScheduledListenableFutureAdapter;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public interface DelayableExecutor
extends AsyncExecutor {
    @Override
    default public <V> Future<V> submit(Callable<V> task) throws RejectedExecutionException {
        return this.schedule(task, 0L, TimeUnit.SECONDS);
    }

    default public ScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit delayTimeUnit) {
        return this.schedule(Executors.callable(command), delay, delayTimeUnit);
    }

    public <V> ScheduledFuture<V> schedule(Callable<V> var1, long var2, TimeUnit var4);

    default public ScheduledListenableFuture<?> scheduleListenable(Runnable command, long delay, TimeUnit delayTimeUnit) {
        ListenableFutureTask<Object> future = new ListenableFutureTask<Object>(command, null);
        ScheduledFuture<?> scheduledFuture = this.schedule(future, delay, delayTimeUnit);
        return new ScheduledListenableFutureAdapter<Object>(future, scheduledFuture);
    }

    default public <V> ScheduledListenableFuture<V> scheduleListenable(Callable<V> callable, long delay, TimeUnit delayTimeUnit) {
        ListenableFutureTask<V> future = new ListenableFutureTask<V>(callable);
        ScheduledFuture<?> scheduledFuture = this.schedule(future, delay, delayTimeUnit);
        return new ScheduledListenableFutureAdapter<V>(future, scheduledFuture);
    }
}

