/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.util.concurrent;

import io.basc.framework.util.concurrent.FailureCallback;
import io.basc.framework.util.concurrent.FutureAdapter;
import io.basc.framework.util.concurrent.ListenableFuture;
import io.basc.framework.util.concurrent.ListenableFutureCallback;
import io.basc.framework.util.concurrent.SuccessCallback;
import java.util.concurrent.ExecutionException;

public abstract class ListenableFutureAdapter<T, S>
extends FutureAdapter<T, S>
implements ListenableFuture<T> {
    protected ListenableFutureAdapter(ListenableFuture<S> adaptee) {
        super(adaptee);
    }

    @Override
    public void addCallback(ListenableFutureCallback<? super T> callback) {
        this.addCallback(callback, callback);
    }

    @Override
    public void addCallback(final SuccessCallback<? super T> successCallback, final FailureCallback failureCallback) {
        ListenableFuture listenableAdaptee = (ListenableFuture)this.getAdaptee();
        listenableAdaptee.addCallback(new ListenableFutureCallback<S>(){

            @Override
            public void onSuccess(S result) {
                Object adapted;
                try {
                    adapted = ListenableFutureAdapter.this.adaptInternal(result);
                }
                catch (ExecutionException ex) {
                    Throwable cause = ex.getCause();
                    this.onFailure(cause != null ? cause : ex);
                    return;
                }
                catch (Throwable ex) {
                    this.onFailure(ex);
                    return;
                }
                successCallback.onSuccess(adapted);
            }

            @Override
            public void onFailure(Throwable ex) {
                failureCallback.onFailure(ex);
            }
        });
    }
}

