/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.util.concurrent;

import io.basc.framework.util.Assert;
import io.basc.framework.util.concurrent.FailureCallback;
import io.basc.framework.util.concurrent.Listenable;
import io.basc.framework.util.concurrent.ListenableFutureCallback;
import io.basc.framework.util.concurrent.SuccessCallback;
import java.util.LinkedList;
import java.util.Queue;

public class ListenableFutureCallbackRegistry<T>
implements Listenable<T> {
    private final Queue<SuccessCallback<? super T>> successCallbacks = new LinkedList<SuccessCallback<? super T>>();
    private final Queue<FailureCallback> failureCallbacks = new LinkedList<FailureCallback>();
    private State state = State.NEW;
    private Object result = null;
    private final Object mutex = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        Object object = this.mutex;
        synchronized (object) {
            this.result = null;
            this.state = State.NEW;
            this.failureCallbacks.clear();
            this.successCallbacks.clear();
        }
    }

    @Override
    public void addCallback(SuccessCallback<? super T> successCallback, FailureCallback failureCallback) {
        if (successCallback != null) {
            this.addSuccessCallback(successCallback);
        }
        if (failureCallback != null) {
            this.addFailureCallback(failureCallback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addCallback(ListenableFutureCallback<? super T> callback) {
        Assert.notNull(callback, "'callback' must not be null");
        Object object = this.mutex;
        synchronized (object) {
            switch (this.state) {
                case NEW: {
                    this.successCallbacks.add(callback);
                    this.failureCallbacks.add(callback);
                    break;
                }
                case SUCCESS: {
                    this.notifySuccess(callback);
                    break;
                }
                case FAILURE: {
                    this.notifyFailure(callback);
                }
            }
        }
    }

    private void notifySuccess(SuccessCallback<? super T> callback) {
        try {
            callback.onSuccess(this.result);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void notifyFailure(FailureCallback callback) {
        try {
            callback.onFailure((Throwable)this.result);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSuccessCallback(SuccessCallback<? super T> callback) {
        Assert.notNull(callback, "'callback' must not be null");
        Object object = this.mutex;
        synchronized (object) {
            switch (this.state) {
                case NEW: {
                    this.successCallbacks.add(callback);
                    break;
                }
                case SUCCESS: {
                    this.notifySuccess(callback);
                    break;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFailureCallback(FailureCallback callback) {
        Assert.notNull((Object)callback, "'callback' must not be null");
        Object object = this.mutex;
        synchronized (object) {
            switch (this.state) {
                case NEW: {
                    this.failureCallbacks.add(callback);
                    break;
                }
                case FAILURE: {
                    this.notifyFailure(callback);
                    break;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void success(T result) {
        Object object = this.mutex;
        synchronized (object) {
            SuccessCallback<? super T> callback;
            this.state = State.SUCCESS;
            this.result = result;
            while ((callback = this.successCallbacks.poll()) != null) {
                this.notifySuccess(callback);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void failure(Throwable ex) {
        Object object = this.mutex;
        synchronized (object) {
            FailureCallback callback;
            this.state = State.FAILURE;
            this.result = ex;
            while ((callback = this.failureCallbacks.poll()) != null) {
                this.notifyFailure(callback);
            }
        }
    }

    private static enum State {
        NEW,
        SUCCESS,
        FAILURE;

    }
}

