/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.util.concurrent;

import io.basc.framework.util.concurrent.FailureCallback;
import io.basc.framework.util.concurrent.ListenableFuture;
import io.basc.framework.util.concurrent.ListenableFutureCallback;
import io.basc.framework.util.concurrent.ScheduledListenableFuture;
import io.basc.framework.util.concurrent.SuccessCallback;
import java.util.concurrent.Delayed;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class ScheduledListenableFutureAdapter<V>
implements ScheduledListenableFuture<V> {
    private final ListenableFuture<? extends V> listenableFuture;
    private final Delayed delayed;

    public ScheduledListenableFutureAdapter(ListenableFuture<? extends V> listenableFuture, Delayed delayed) {
        this.listenableFuture = listenableFuture;
        this.delayed = delayed;
    }

    @Override
    public long getDelay(TimeUnit unit) {
        return this.delayed.getDelay(unit);
    }

    @Override
    public int compareTo(Delayed o) {
        return this.delayed.compareTo(o);
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return this.listenableFuture.cancel(mayInterruptIfRunning);
    }

    @Override
    public boolean isCancelled() {
        return this.listenableFuture.isCancelled();
    }

    @Override
    public boolean isDone() {
        return this.listenableFuture.isDone();
    }

    @Override
    public V get() throws InterruptedException, ExecutionException {
        return this.listenableFuture.get();
    }

    @Override
    public V get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.listenableFuture.get(timeout, unit);
    }

    @Override
    public void addCallback(ListenableFutureCallback<? super V> callback) {
        this.listenableFuture.addCallback(callback);
    }

    @Override
    public void addCallback(SuccessCallback<? super V> successCallback, FailureCallback failureCallback) {
        this.listenableFuture.addCallback(successCallback, failureCallback);
    }
}

