/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.util.concurrent;

import io.basc.framework.util.Assert;
import io.basc.framework.util.ConcurrencyThrottleSupport;
import io.basc.framework.util.CustomizableThreadCreator;
import io.basc.framework.util.concurrent.AsyncExecutor;
import io.basc.framework.util.concurrent.TaskDecorator;
import java.io.Serializable;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.ThreadFactory;

public class SimpleAsyncExecutor
extends CustomizableThreadCreator
implements AsyncExecutor,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final int UNBOUNDED_CONCURRENCY = -1;
    public static final int NO_CONCURRENCY = 0;
    private final ConcurrencyThrottleAdapter concurrencyThrottle = new ConcurrencyThrottleAdapter();
    private ThreadFactory threadFactory;
    private TaskDecorator taskDecorator;

    public SimpleAsyncExecutor() {
    }

    public SimpleAsyncExecutor(String threadNamePrefix) {
        super(threadNamePrefix);
    }

    public SimpleAsyncExecutor(ThreadFactory threadFactory) {
        this.threadFactory = threadFactory;
    }

    public void setThreadFactory(ThreadFactory threadFactory) {
        this.threadFactory = threadFactory;
    }

    public final ThreadFactory getThreadFactory() {
        return this.threadFactory;
    }

    public final void setTaskDecorator(TaskDecorator taskDecorator) {
        this.taskDecorator = taskDecorator;
    }

    public void setConcurrencyLimit(int concurrencyLimit) {
        this.concurrencyThrottle.setConcurrencyLimit(concurrencyLimit);
    }

    public final int getConcurrencyLimit() {
        return this.concurrencyThrottle.getConcurrencyLimit();
    }

    public final boolean isThrottleActive() {
        return this.concurrencyThrottle.isThrottleActive();
    }

    @Override
    public void execute(Runnable task) {
        Runnable taskToUse;
        Assert.notNull((Object)task, "Runnable must not be null");
        Runnable runnable = taskToUse = this.taskDecorator != null ? this.taskDecorator.decorate(task) : task;
        if (this.isThrottleActive()) {
            this.concurrencyThrottle.beforeAccess();
            this.doExecute(new ConcurrencyThrottlingRunnable(taskToUse));
        } else {
            this.doExecute(taskToUse);
        }
    }

    @Override
    public Future<?> submit(Runnable task) {
        FutureTask<Object> future = new FutureTask<Object>(task, null);
        this.execute(future);
        return future;
    }

    public <T> Future<T> submit(Callable<T> task) {
        FutureTask<T> future = new FutureTask<T>(task);
        this.execute(future);
        return future;
    }

    protected void doExecute(Runnable task) {
        Thread thread = this.threadFactory != null ? this.threadFactory.newThread(task) : this.createThread(task);
        thread.start();
    }

    private class ConcurrencyThrottlingRunnable
    implements Runnable {
        private final Runnable target;

        public ConcurrencyThrottlingRunnable(Runnable target) {
            this.target = target;
        }

        @Override
        public void run() {
            try {
                this.target.run();
            }
            finally {
                SimpleAsyncExecutor.this.concurrencyThrottle.afterAccess();
            }
        }
    }

    private static class ConcurrencyThrottleAdapter
    extends ConcurrencyThrottleSupport {
        private static final long serialVersionUID = 1L;

        private ConcurrencyThrottleAdapter() {
        }

        @Override
        protected void beforeAccess() {
            super.beforeAccess();
        }

        @Override
        protected void afterAccess() {
            super.afterAccess();
        }
    }
}

