/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.util.concurrent;

import io.basc.framework.lang.Nullable;
import io.basc.framework.logger.Logger;
import io.basc.framework.logger.LoggerFactory;
import io.basc.framework.util.Assert;
import io.basc.framework.util.XUtils;
import io.basc.framework.util.concurrent.AsyncExecutor;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;

public class TaskQueue
extends Thread
implements AsyncExecutor {
    private static Logger logger = LoggerFactory.getLogger(TaskQueue.class);
    private final BlockingQueue<Runnable> queue;
    private boolean tryGet = true;
    private AtomicBoolean started = new AtomicBoolean();

    public TaskQueue() {
        this(new LinkedBlockingQueue<Runnable>());
    }

    public TaskQueue(BlockingQueue<Runnable> queue) {
        this.queue = queue;
        this.setDaemon(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Runnable poll() {
        BlockingQueue<Runnable> blockingQueue = this.queue;
        synchronized (blockingQueue) {
            return (Runnable)this.queue.poll();
        }
    }

    public boolean isTryGet() {
        return this.tryGet;
    }

    public void setTryGet(boolean tryGet) {
        this.tryGet = tryGet;
    }

    protected void run(Runnable task) throws Throwable {
        task.run();
        if (this.isTryGet() && task instanceof Future) {
            ((Future)((Object)task)).get();
        }
    }

    public boolean isStarted() {
        return this.started.get();
    }

    @Override
    public synchronized void start() {
        if (this.started.compareAndSet(false, true)) {
            super.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (!Thread.currentThread().isInterrupted()) {
            Runnable task;
            BlockingQueue<Runnable> blockingQueue = this.queue;
            synchronized (blockingQueue) {
                try {
                    task = this.queue.take();
                }
                catch (InterruptedException e) {
                    break;
                }
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Thread[{}] execute task: {}", this.getName(), task);
            }
            try {
                this.run(task);
            }
            catch (Throwable e) {
                logger.error(e, "Thread[{}] execute task fail: {}", this.getName(), task);
            }
        }
    }

    public <T> Future<T> submit(final Callable<T> task) {
        Assert.requiredArgument(task != null, "task");
        final String taskId = XUtils.getUUID();
        FutureTask future = new FutureTask<T>(task){

            @Override
            public String toString() {
                return taskId + "[" + task.toString() + "]";
            }
        };
        if (!this.isStarted()) {
            this.start();
        }
        if (this.isInterrupted()) {
            throw new RejectedExecutionException(String.valueOf(future));
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Thread[{}] submit task: {}", Thread.currentThread().getName(), future);
        }
        if (!this.queue.offer(future)) {
            throw new RejectedExecutionException(String.valueOf(future));
        }
        return future;
    }
}

