/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.util.page;

import io.basc.framework.util.AbstractCursor;
import io.basc.framework.util.Cursor;
import io.basc.framework.util.page.Pageable;
import io.basc.framework.util.page.Pageables;
import java.math.BigInteger;
import java.util.NoSuchElementException;

public class AllPageable<S extends Pageables<K, T>, K, T>
implements Pageable<K, T> {
    protected final S source;

    public AllPageable(S source) {
        this.source = source;
    }

    @Override
    public K getCursorId() {
        return this.source.getCursorId();
    }

    @Override
    public K getNextCursorId() {
        return null;
    }

    @Override
    public boolean hasNext() {
        return false;
    }

    @Override
    public Cursor<T> iterator() {
        return new All(this.source);
    }

    private class All
    extends AbstractCursor<T, All> {
        private Pageables<K, T> pageables;
        private Cursor<T> cursor;
        private BigInteger position;

        public All(Pageables<K, T> pageables) {
            this.pageables = pageables;
            this.cursor = pageables.iterator();
            super.onClose(() -> this.cursor.close());
            this.position = this.cursor.getPosition();
        }

        @Override
        public BigInteger getPosition() {
            return this.position;
        }

        @Override
        public boolean hasNext() {
            if (this.cursor.hasNext()) {
                return true;
            }
            if (this.pageables.hasNext()) {
                this.pageables = this.pageables.next();
                this.cursor = this.pageables.iterator();
                super.onClose(() -> this.cursor.close());
                this.position = this.position.add(this.cursor.getPosition());
                return this.hasNext();
            }
            return false;
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            try {
                Object e = this.cursor.next();
                return e;
            }
            finally {
                this.position = this.position.add(BigInteger.ONE);
            }
        }
    }
}

