/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.util.page;

import io.basc.framework.util.Assert;
import io.basc.framework.util.Cursor;
import io.basc.framework.util.page.Paginations;
import java.io.Serializable;
import java.util.List;

public class InMemoryPaginations<T>
implements Paginations<T>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final List<? extends T> source;
    private final int start;
    private final int count;

    public InMemoryPaginations(List<? extends T> source, int start, int count) {
        Assert.requiredArgument(source != null, "source");
        Assert.isTrue(start >= 0, "start[" + start + "] cannot be less than 0");
        Assert.isTrue(count > 0, "count[" + count + "] greater than 0 is required");
        this.start = start;
        this.source = source;
        this.count = count;
    }

    @Override
    public long getTotal() {
        return this.source.size();
    }

    @Override
    public long getCount() {
        return this.count;
    }

    @Override
    public Long getCursorId() {
        return this.start;
    }

    @Override
    public Long getNextCursorId() {
        int end = this.start + this.count;
        if (end <= 0 || end >= this.source.size()) {
            return null;
        }
        return Math.min(end, this.source.size());
    }

    @Override
    public Cursor<T> iterator() {
        int end = Math.min(this.start + this.count, this.source.size());
        if (this.start >= end) {
            return Cursor.empty();
        }
        return Cursor.of(this.source.subList(this.start, end).iterator());
    }

    @Override
    public Paginations<T> jumpTo(Long cursorId, long count) {
        Assert.requiredArgument(cursorId != null, "cursorId");
        Assert.isTrue(cursorId <= Integer.MAX_VALUE);
        Assert.isTrue(count <= Integer.MAX_VALUE);
        return new InMemoryPaginations<T>(this.source, cursorId.intValue(), (int)count);
    }
}

