/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.util.page;

import io.basc.framework.util.StaticSupplier;
import io.basc.framework.util.page.Pageables;
import java.util.Iterator;
import java.util.function.Function;
import java.util.function.Supplier;

public final class PageablesIterator<E extends Pageables<?, ?>>
implements Iterator<E> {
    private E pageables;
    private Supplier<E> current;
    private final Function<? super E, ? extends E> next;

    public PageablesIterator(E pageables, Function<? super E, ? extends E> next) {
        this.pageables = pageables;
        this.current = new StaticSupplier<E>(pageables);
        this.next = next;
    }

    @Override
    public boolean hasNext() {
        if (this.current != null) {
            return true;
        }
        return this.pageables.hasNext();
    }

    @Override
    public E next() {
        if (this.current != null) {
            Pageables value = (Pageables)this.current.get();
            this.current = null;
            return (E)value;
        }
        this.pageables = (Pageables)this.next.apply(this.pageables);
        return this.pageables;
    }
}

