/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.util.page;

import io.basc.framework.util.page.MapPagination;
import io.basc.framework.util.page.Page;
import io.basc.framework.util.page.PageSupport;
import io.basc.framework.util.page.SharedPagination;
import java.util.function.Function;

public interface Pagination<T>
extends Page<Long, T> {
    default public long getPageNumber() {
        return PageSupport.getPageNumber((Long)this.getCursorId(), this.getCount());
    }

    default public long getPages() {
        return PageSupport.getPages(this.getTotal(), this.getCount());
    }

    default public boolean hasPrevious() {
        return this.getPageNumber() > 1L;
    }

    @Override
    default public Long getNextCursorId() {
        Long start = (Long)this.getCursorId();
        if (start == null) {
            return null;
        }
        if (!PageSupport.hasMore(this.getTotal(), start, this.getCount())) {
            return null;
        }
        return PageSupport.getNextStart(start, this.getCount());
    }

    @Override
    default public Pagination<T> shared() {
        return new SharedPagination(this);
    }

    @Override
    default public <TT> Pagination<TT> map(Function<? super T, ? extends TT> map) {
        return new MapPagination<Pagination, T, TT>(this, map);
    }
}

