/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.util.page;

import io.basc.framework.util.page.AllPagination;
import io.basc.framework.util.page.PageSupport;
import io.basc.framework.util.page.Pages;
import io.basc.framework.util.page.Pagination;
import io.basc.framework.util.page.SharedPaginations;
import io.basc.framework.util.page.StreamPaginations;

public interface Paginations<T>
extends Pagination<T>,
Pages<Long, T> {
    default public Paginations<T> previous() {
        return this.jumpToPage(this.getPageNumber() - 1L);
    }

    default public Paginations<T> jumpToPage(long pageNumber) {
        return this.jumpToPage(pageNumber, this.getCount());
    }

    default public Paginations<T> jumpToPage(long pageNumber, long count) {
        return this.jumpTo(PageSupport.getStart(pageNumber, count), count);
    }

    @Override
    default public Paginations<T> limit(long maxPageNumber) {
        return new StreamPaginations(this.getTotal(), (Long)Math.min(this.getTotal(), PageSupport.getStart(maxPageNumber, this.getCount())), this.getCount(), (k, c) -> this.jumpTo((Long)k, c).iterator());
    }

    default public Paginations<T> jumpTo(Long cursorId) {
        return this.jumpTo(cursorId, this.getCount());
    }

    @Override
    default public Paginations<T> shared() {
        return new SharedPaginations(this);
    }

    default public Pagination<T> all() {
        return new AllPagination(this);
    }

    public Paginations<T> jumpTo(Long var1, long var2);
}

