/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.util.page;

import io.basc.framework.core.reflect.ReflectionUtils;
import io.basc.framework.util.Cursor;
import io.basc.framework.util.page.Pageable;
import java.io.Serializable;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class SharedPageable<K, T>
implements Pageable<K, T>,
Serializable {
    private static final long serialVersionUID = 1L;
    private K cursorId;
    private K nextCursorId;
    private List<T> list;

    public SharedPageable() {
    }

    public SharedPageable(K cursorId) {
        this(cursorId, Collections.emptyList(), null);
    }

    protected Iterator<? extends T> getIterator() {
        return Collections.emptyIterator();
    }

    public SharedPageable(K cursorId, List<T> list, K nextCursorId) {
        this.cursorId = cursorId;
        this.nextCursorId = nextCursorId;
        this.list = list;
    }

    public SharedPageable(Pageable<K, T> pageable) {
        this(pageable.getCursorId(), pageable.getList(), pageable.getNextCursorId());
    }

    @Override
    public K getCursorId() {
        return this.cursorId;
    }

    @Override
    public K getNextCursorId() {
        return this.nextCursorId;
    }

    public void setCursorId(K cursorId) {
        this.cursorId = cursorId;
    }

    public void setNextCursorId(K nextCursorId) {
        this.nextCursorId = nextCursorId;
    }

    @Override
    public List<T> getList() {
        return this.list == null ? Collections.emptyList() : Collections.unmodifiableList(this.list);
    }

    public void setList(List<T> list) {
        this.list = list;
    }

    public String toString() {
        return ReflectionUtils.toString(this);
    }

    @Override
    public Cursor<T> iterator() {
        return Cursor.of(this.list);
    }
}

